---
id: 6733aad43b3ebff588a26fb5
title: What Are Regular Expressions, and What Are Some Common Methods?
challengeType: 19
dashedName: what-are-regular-expressions-and-what-are-some-common-methods
---

# --interactive--

Regular expressions, or regex, are a feature supported by many different programming languages.

A regular expression is a special syntax to create a "pattern", which you can then use to check against a string, extract text, and more.

Let's take a look at a basic regular expression:

```js
const regex = /freeCodeCamp/;
```

Notice how, in JavaScript, you define a regular expression by creating your pattern between two forward slashes (`/`). Try not to confuse this with a comment, where the text comes after both forward slashes.

This particular regular expression will match the text `freeCodeCamp`, with capital `C`s, anywhere in a string. But how can you actually do that?

That brings us to our first method – the `test()` method. The `test()` method is present on `RegExp` objects, which are objects representing a regular expression (such as the one we just defined).

The `test()` method accepts a string, which is the string to test for matches against the regular expression. For example, let's try testing the string `e`:

:::interactive_editor

```js
const regex = /freeCodeCamp/;
const test = regex.test("e");
console.log(test);
```

:::

You can see we've called the `test()` method on our new regex, and passed the string `e` as the argument. 

The `test()` method returned `false` because the string `e` does not match the pattern `freeCodeCamp`. Even though the pattern `freeCodeCamp` includes the letter `e`, that's the opposite direction of how regular expressions work.

Let's take a look at a few more examples. Take a moment to consider these:

:::interactive_editor

```js
const regex = /freeCodeCamp/;
console.log(regex.test("freeCodeCamp"));
console.log(regex.test("freeCodeCamp is great"));
console.log(regex.test("I love freeCodeCamp"));
console.log(regex.test("freecodecamp"));
console.log(regex.test("FREECODECAMP"));
console.log(regex.test("free"));
console.log(regex.test("code"));
console.log(regex.test("camp"));
```

:::

Notice how the first three strings returned `true`. These strings all contain the text, `freeCodeCamp`, exactly, somewhere in the string. 

Lines 5 and 6 return `false`. While they contain the text `freecodecamp`, the case does not match. Regular expressions are case-sensitive by default.

Finally, while the last three contain a portion of the pattern, the strings do not contain the entire pattern.

The `test()` method returns a `boolean`, indicating whether the string matches the regular expression at all.

But what if you wanted more information than that? Well, strings have a `match()` method. This method accepts a regular expression, although you can also pass a string which will be constructed into a regular expression.

`match()` returns the match array for the string. What's a match array? Well, let's take a look:

```js
const regex = /freeCodeCamp/;
const match = "freeCodeCamp".match(regex);
console.log(match);
```

If we run this, we get an array back! But it's a strange looking array. It's got some extra properties:

```js
// [
//   'freeCodeCamp',
//   index: 0,
//   input: 'freeCodeCamp',
//   groups: undefined
// ]
```

The `groups` property would show any captured groups. You will learn what that means in a future lesson.

The `index` property tells you at what character in the string the match was found. In our case, it was found at the beginning of the string.

The `input` property tells you the string the `match()` method was called on.

Let's try a few more again, and see how the result changes:

```js
const regex = /freeCodeCamp/;
console.log("freeCodeCamp".match(regex)); // ['freeCodeCamp', index: 0, input: 'freeCodeCamp', groups: undefined]
console.log("freeCodeCamp is great".match(regex)); // ['freeCodeCamp', index: 0, input: 'freeCodeCamp is great', groups: undefined]
console.log("I love freeCodeCamp".match(regex)); // ['freeCodeCamp', index: 7, input: 'I love freeCodeCamp', groups: undefined]
console.log("freecodecamp".match(regex)); // null
console.log("FREECODECAMP".match(regex)); // null
console.log("free".match(regex)); // null
```

We know already that the first three strings should produce a match, so let's take a look at those:

```js
// ['freeCodeCamp', index: 0, input: 'freeCodeCamp', groups: undefined]
// ['freeCodeCamp', index: 0, input: 'freeCodeCamp is great', groups: undefined]
// ['freeCodeCamp', index: 7, input: 'I love freeCodeCamp', groups: undefined]
```

Is that what you expected? You can see how the `input` and `index` have changed depending on the string provided, and the location of the match in the string. 

The other three lines, which do not match, return `null` instead of an array.

Now that we can test and match strings with our regular expression, what if we want to replace the content of a string? Maybe someone has written `freecodecamp` in all lowercase, and we want to automatically fix the casing for them.

First, we need to update our regular expression to match the lowercase form of `freecodecamp`, and create our test string:

```js
const regex = /freecodecamp/;
const str = "freecodecamp is rly kewl";
```

Now, strings have a `replace()` method which accepts two arguments: the regular expression to match (or a string, if you don't need all of the features of regex), and the string to replace the match with (or a function to run against each match). 

So if we wanted to replace our `freecodecamp` with the proper casing:

:::interactive_editor

```js
const regex = /freecodecamp/;
const str = "freecodecamp is rly kewl";
const replaced = str.replace(regex, "freeCodeCamp");
console.log(replaced);
```

:::

You can see that `replace()` returns the updated string with the matching pattern `replaced`.

Regular expressions, and all of the methods associated with them, can seem complex and overwhelming. But you'll get the chance to explore them further in this next set of lessons.

# --questions--

## --text--

In JavaScript, how is a basic regular expression defined? 

## --answers--

Using single quotes: `'pattern'`

### --feedback--

The lesson shows a specific syntax for defining a regular expression.

---

Using double quotes: `"pattern"`

### --feedback--

The lesson shows a specific syntax for defining a regular expression.

---

Using forward slashes: `/pattern/`

---

Using parentheses: `(pattern)`

### --feedback--

The lesson shows a specific syntax for defining a regular expression.

## --video-solution--

3

## --text--

What does the `test()` method return when used with a regular expression? 

## --answers--

An array of matches.

### --feedback--

Think about what type of result the `test()` method provides.

---

A boolean value.

---

The matched string.

### --feedback--

Think about what type of result the `test()` method provides.

---

The index of the match.

### --feedback--

Think about what type of result the `test()` method provides.

## --video-solution--

2

## --text--

What happens when you use the `match()` method with a regular expression on a string that doesn't contain a match?

## --answers--

It returns an empty array.

### --feedback--

The lesson describes the result of `match()` for non-matching strings.

---

It returns `false`.

### --feedback--

The lesson describes the result of `match()` for non-matching strings.

---

It returns `null`.

---

It throws an error.

### --feedback--

The lesson describes the result of `match()` for non-matching strings.

## --video-solution--

3
