---
id: 672bbed37c6f51aa3a15e78c
title: What Are Pseudo-elements, and How Do They Work?
challengeType: 19
dashedName: what-are-pseudo-elements
---

# --interactive--

One of the most interesting aspects of CSS is the use of pseudo-elements. In this context, "pseudo" means "not real", so pseudo-elements are virtual or synthetic elements that don't directly match any actual HTML elements. They allow you to style specific parts of an element or insert content without adding extra HTML.

To apply a pseudo-element, attach it to the original element's selector using a double colon (`::`). Note that the selector can be any type, such as a class or ID selector. Here's what the basic syntax of pseudo-elements looks like:

```css
selector::pseudo-element {
  property: value;
}
```

This double colon is what distinguishes pseudo-elements from pseudo-classes, which use a single colon.

Pseudo-elements allow you to style specific parts of an element's content or insert content before or after it, but they cannot exist independently. The element to which a pseudo-element is attached is called its originating element.

Let's start by looking at examples for the `::before` and `::after` pseudo-elements. As their names suggest, `::before` lets you insert content just before the element's content while `::after` lets you insert content after it.

Here is an example of a button element. In the CSS, we will use absolute positioning and the `::before` pseudo-element to add a star before the button's `Learn More` text. You will learn more about absolute positioning in future lessons.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<button class="cta-button">Learn More</button>
```

```css
.cta-button {
  background-color: lightseagreen;
  color: white;
  border: none;
  padding: 10px 20px;
  cursor: pointer;
  position: relative;
}

.cta-button::before {
  content: "⭐";
  position: absolute;
  left: 3px;
  top: 8px;
  font-size: 0.75rem;
}
```

:::

The `content` property is used to represent the content you wish to add before the button text. In this example, we are adding a star. You'll notice that you can not only insert content but also style it. Here's an example of the `::after` pseudo-element with the same button:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<button class="cta-button">Learn More</button>
```

```css
.cta-button {
  background-color: orange;
  border: none;
  padding: 10px 30px;
  cursor: pointer;
  position: relative;
}

.cta-button::after {
  content: '➡️';
  position: absolute;
  right: 5px;
  bottom: 6px;
  font-size: 1.125rem;
  transition: transform 0.3s ease;
}
```

:::

In the `::after` pseudo-element, the `transition` property is used to animate changes over 0.3 seconds with an easing effect, creating a smooth and gradual transformation rather than a sudden one. You will learn more about the `transition` property in future lessons. 

You can also attach a pseudo-class to the content you insert into another content with the `::before` and `::after` pseudo-elements. For example, a hover state for the content. Here's an example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<button class="cta-button">Learn More</button>
```

```css
.cta-button {
  background-color: orange;
  border: none;
  padding: 10px 30px;
  cursor: pointer;
  position: relative;
}

.cta-button::after {
  content: "➡️";
  position: absolute;
  right: 5px;
  bottom: 6px;
  font-size: 1.125rem;
  transition: transform 0.3s ease;
}

.cta-button:hover::after {
  transform: translateX(2px);
}
```

:::

With `transform: translateX(2px)` in the hover state, the content gets pushed to the right by `2px` any time the user hovers on the button. The transition property in the `::after` itself ensures the process takes `0.3s`.

That's what the `transform` property does – it allows you to rotate, skew, scale, or translate an element in a particular direction. You will learn more about that in future lessons.

In the next example, we will look at the `::first-letter` pseudo-element. The `::first-letter` pseudo-element targets the first letter of an element's content, allowing you to style it. Here's an example of some paragraph text. If we want to style the first letter, we can use the `::first-letter` pseudo-element like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<p>freeCodeCamp lets you learn to code without having to pay.</p>
```

```css
p::first-letter {
  font-size: 4rem;
}
```

:::

In the last example, we will look at the `::marker` pseudo-element, which lets you select the marker, bullet or numbering of list items for styling. The `::marker` pseudo-element offers a way to enhance your website's brand identity by customizing list markers to match your color scheme.

Here's an example of an unordered list and an ordered list. To change the list item's marker color and size, you can use the `::marker` pseudo-element like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<ul>
  <li>Unordered list item 1</li>
  <li>Unordered list item 2</li>
  <li>Unordered list item 3</li>
  <li>Unordered list item 4</li>
</ul>

<ol>
  <li>Ordered list item 1</li>
  <li>Ordered list item 2</li>
  <li>Ordered list item 3</li>
  <li>Ordered list item 4</li>
</ol>
```

```css
li::marker {
  color: crimson;
  font-size: 1.5em;
  font-weight: bold;
}
```

:::

In this lesson, we have covered only a few pseudo-elements. But there are many more like the `::placeholder`, `::spelling-error` and `::selection` that I encourage you to explore on your own.

# --questions--

## --text--

Which of these best describes the relationship between pseudo-elements and their originator element?

## --answers--

Pseudo-elements can exist independently of the originator element.

### --feedback--

Think about how pseudo-elements style or insert content.

---

Pseudo-elements must always be declared before the originator element.

### --feedback--

Think about how pseudo-elements style or insert content.

---

Pseudo-elements depend on the originator element and cannot exist independently.

---

Pseudo-elements are used to create new HTML elements.

### --feedback--

Think about how pseudo-elements style or insert content.

## --video-solution--

3

## --text--

Which of these correctly distinguishes pseudo-elements from pseudo-classes?

## --answers--

Pseudo-elements use a single colon, while pseudo-classes use a double colon.

### --feedback--

Think about how pseudo-elements are visually represented in CSS.

---

Pseudo-elements use a double colon, while pseudo-classes use a single colon.

---

Both pseudo-elements and pseudo-classes use the same colon notation.

### --feedback--

Think about how pseudo-elements are visually represented in CSS.

---

Pseudo-classes require a double colon, while pseudo-elements do not.

### --feedback--

Think about how pseudo-elements are visually represented in CSS.

## --video-solution--

2

## --text--

Which of these best describes the function of pseudo-elements in CSS?

## --answers--

They add new HTML elements to the document.

### --feedback--

Think about how pseudo-elements target specific portions of content.

---

They style specific parts of an element's content without adding extra HTML tags.

---

They replace the entire content of an element with new content.

### --feedback--

Think about how pseudo-elements target specific portions of content.

---

They modify the structure of the HTML document.

### --feedback--

Think about how pseudo-elements target specific portions of content.

## --video-solution--

2
