---
id: 673271a8998ddfd97578d095
title: How Do the Increment and Decrement Operators Work?
challengeType: 19
dashedName: how-do-the-increment-and-decrement-operators-work
---

# --interactive--

If you're working with numbers and need to increase or decrease a value by one, the increment and decrement operators make the job easier. Let's break it down in a simple way.

The increment and decrement operators are represented by `++` and `--`, respectively. They both allow you to adjust the value of a variable by `1`.

Instead of writing something like `x = x + 1` or `x = x - 1`, you can simply use `x++` to add `1`, or `x--` to subtract `1`. It's faster, cleaner, and easier to read.

There's a twist to how the increment and decrement operators work: they come in two forms, prefix and postfix, with the difference being when the value gets updated. For the increment operator, prefix is `++x` and postfix is `x++`.

Prefix (`++x`) increases the value of the variable first, then returns a new value. Postfix (`x++`) returns the current value of the variable first, then increases it:

:::interactive_editor

```js
let x = 5;

console.log(++x); // 6
console.log(x); // 6
```

:::

In the code above, `++x` means "increment `x` first, then use it". So when you log `++x`, you immediately get the incremented value, which is `6`.

Now, let's take a look at an example using the postfix:

:::interactive_editor

```js
let y = 5;

console.log(y++); // 5
console.log(y); // 6
```

:::

In this example, `y++` means "use `y` first, then increment it". When you log `y++`, you get `5`, but `y` becomes `6` after that line of code.

The decrement operator does the same thing as increment, except it decreases the value by `1`. Again, there are two forms: prefix (`--x`) decreases the value of the variable first, then returns the new value. And postfix (`x--`) returns the current value first, then decreases it:

:::interactive_editor

```js
let x = 5;
console.log(--x); // 4
console.log(x); // 4

let y = 5;
console.log(y--); // 5
console.log(y); // 4
```

:::

So, which should you use: prefix or postfix? In many cases, it doesn't matter which one you use. Both get the job done. However, if you're using the value immediately in an expression, the difference becomes important. Let's take a look at this example:

:::interactive_editor

```js
let a = 5;
let b = ++a;
console.log(b); // 6 (a was incremented before assignment)

let c = 5;
let d = c++;
console.log(d); // 5 (c was incremented after assignment)
```

:::

So, if you need the updated value right away, use prefix. If you want the current value first and you don’t care about the increment until later, go with postfix.

# --questions--

## --text--

Which operators in JavaScript allow you to adjust the value of a variable by 1?

## --answers--

`+` and `-`.

### --feedback--

Think about the operators that increase or decrease a value by exactly 1.

---

`*` and `/`.

### --feedback--

Think about the operators that increase or decrease a value by exactly 1.

---

`++` and `--`.

---

`&&` and `||`.

### --feedback--

Think about the operators that increase or decrease a value by exactly 1.

## --video-solution--

3

## --text--

Which form of the increment or decrement operator should you use if you need the updated value immediately in an expression?

## --answers--

Postfix (`value++` or `value--`).

### --feedback--

Think about which form updates the value before the expression is evaluated.

---

Prefix (`++value` or `--value`).

---

Either prefix or postfix, it doesn't matter.

### --feedback--

Think about which form updates the value before the expression is evaluated.

---

Neither, you should use addition or subtraction instead.

### --feedback--

Think about which form updates the value before the expression is evaluated.

## --video-solution--

2

## --text--

In which forms do the increment and decrement operators come in JavaScript?

## --answers--

Prefix and postfix.

---

Addition and subtraction.

### --feedback--

Think about the two different ways these operators can be applied.

---

Multiplication and division.

### --feedback--

Think about the two different ways these operators can be applied.

---

Left and right.

### --feedback--

Think about the two different ways these operators can be applied.

## --video-solution--

1
