---
id: 6732808f3221720adc833e81
title: How Do the parseFloat() and parseInt() Methods Work?
challengeType: 19
dashedName: how-do-the-parsefloat-and-parseint-methods-work
---

# --interactive--

`parseFloat()` and `parseInt()` are two essential methods in JavaScript for converting strings to numbers. These methods are particularly useful when dealing with user input or processing data that comes in string format but needs to be treated as numerical values.

Let's start with `parseFloat()`. This method parses a string argument and returns a floating-point number. It's designed to extract a number from the beginning of a string, even if the string contains non-numeric characters later on. Remember that floats are numbers with decimal points. Here's how `parseFloat()` works:

:::interactive_editor

```js
console.log(parseFloat("3.14"));     // 3.14
console.log(parseFloat("3.14 abc")); // 3.14
console.log(parseFloat("3.14.5"));   // 3.14
console.log(parseFloat("abc 3.14")); // NaN
```

:::

As you can see, `parseFloat()` starts parsing from the beginning of the string and continues until it encounters a character that can't be part of a floating-point number. If it can't find a valid number at the start of the string, it returns `NaN` (Not a Number).

`parseInt()`, on the other hand, parses a string argument and returns an integer. Like `parseFloat()`, it starts from the beginning of the string, but it stops at the first non-digit character. Here's how `parseInt()` works:

:::interactive_editor

```js
console.log(parseInt("42"));       // 42
console.log(parseInt("42px"));     // 42
console.log(parseInt("3.14"));     // 3
console.log(parseInt("abc123"));   // NaN
```

:::

`parseInt()` stops parsing at the first non-digit it encounters. For floating-point numbers, it returns only the integer part. If it can't find a valid integer at the start of the string, it returns `NaN`.

Both methods have some noteworthy behaviors. They ignore leading whitespace:

:::interactive_editor

```js
console.log(parseFloat("  3.14"));  // 3.14
console.log(parseInt("  42"));      // 42
```

:::

They handle plus and minus signs at the beginning of the string:

:::interactive_editor

```js
console.log(parseFloat("+3.14"));  // 3.14
console.log(parseInt("-42"));      // -42
```

:::

It's worth noting that while these methods are powerful, they have some limitations. For instance, they don't handle all number formats, such as scientific notation, directly. For more complex parsing needs, you might need to use additional techniques or libraries.

In conclusion, `parseFloat()` and `parseInt()` are valuable tools for converting strings to numbers in JavaScript. Understanding how they work and their specific behaviors allows you to handle numeric data more effectively in your applications, especially when dealing with user inputs or external data sources.

# --questions--

## --text--

What will be the output of the following code?

```js
console.log(parseInt("10.99"));
```

## --answers--

`10.99`

### --feedback--

Consider how `Number.parseInt()` handles decimal points.

---

`10`

---

`11`

### --feedback--

Consider how `Number.parseInt()` handles decimal points.

---

`NaN`

### --feedback--

Consider how `Number.parseInt()` handles decimal points.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
console.log(parseInt("  -42abc"));
```

## --answers--

`-42`

---

`NaN`

### --feedback--

Consider how `Number.parseInt()` handles leading whitespace and non-digit characters.

---

`42`

### --feedback--

Consider how `Number.parseInt()` handles leading whitespace and non-digit characters.

---

`"-42abc"`

### --feedback--

Consider how `Number.parseInt()` handles leading whitespace and non-digit characters.

## --video-solution--

1

## --text--

What will `parseFloat("3.14.15")` return?

## --answers--

`3.1415`

### --feedback--

Consider how `parseFloat()` handles multiple decimal points in a string.

---

`3.14`

---

`NaN`

### --feedback--

Consider how `parseFloat()` handles multiple decimal points in a string.

---

`3`

### --feedback--

Consider how `parseFloat()` handles multiple decimal points in a string.

## --video-solution--

2
