---
id: 6732c05595ca7d422b9e55ff
title: What Is the For...in Loop, and When Should You Use It?
challengeType: 19
dashedName: what-is-the-for-in-loop-and-when-should-you-use-it
---

# --interactive--

A `for...in` loop is best used when you need to loop over the properties of an object. This loop will iterate over all enumerable properties of an object, including inherited properties and non-numeric properties.

An inherited property is a property that is inherited from the object's prototype chain. A non-numeric property is a property that is not a number or a string that can be converted to a number.

Here is the basic syntax of a `for...in` loop:

```js
for (variable in object) {
  // code block to be executed
}
```

The variable in the example represents the current property of the object that is being looped over.

Let's take a look at a few examples so you can better understand how the `for...in` loop works.

In this first example we have a `fruit` object and we want to loop over each property and log the value to the console.

:::interactive_editor

```js
const fruit = {
  name: 'apple',
  color: 'red',
  price: 0.99
};

for (const prop in fruit) {
  console.log(fruit[prop]);
}
```

:::

The `prop` variable represents the current property of the object. `fruit[prop]` is used to access the value of each property.

For the first iteration, `prop` will be `name`. For the second iteration, `prop` will be `color`, and so on.

The results logged to the console will be `apple`, `red`, and `0.99`.

In this second example, we have a nested object and we want to loop over each property and log the value to the console.

:::interactive_editor

```js
const person = {
  name: 'John',
  age: 30,
  address: {
    street: '123 Main St',
    city: 'Anytown',
    state: 'CA'
  }
};

for (const prop in person) {
  console.log(person[prop]);
}
```

:::

The `address` property is an object itself. The `for...in` loop will also loop over the properties of the `person` object and log the entire `address` object to the console.

Here is what the result will look like in the console:

```md
John
30
{ street: '123 Main St', city: 'Anytown', state: 'CA' }
```

If you want to loop over the properties of the `address` object, you can nest another `for...in` loop inside the first one.

:::interactive_editor

```js
const person = {
  name: 'John',
  age: 30,
  address: {
    street: '123 Main St',
    city: 'Anytown',
    state: 'CA'
  }
};

function isObject(obj) {
  return typeof obj === 'object' && !Array.isArray(obj) && obj !== null;
}

for (const prop in person) {
  if (isObject(person[prop])) {
    for (const nestedProp in person[prop]) {
      console.log(person[prop][nestedProp]);
    }
  } else {
    console.log(person[prop]);
  }
}
```

:::

In this example, we have a custom function `isObject` that checks if the value is an object.

The `Array.isArray` method is used to check if the value is an array. By placing the logical NOT operator (`!`) in front of the method, we are checking if the value is not an array.

The reason why we can't just use `typeof` equals `'object'` is because arrays are also considered objects in JavaScript. We want to exclude arrays from the check.

Also, due to a historical bug in JavaScript, `typeof null` returns `'object'`. So we want to also exclude `null` values from the check.

If the condition is true, we nest another `for...in` loop that will loop over the properties of the nested object and log the value to the console.

The `nestedProp` variable represents the current property of the nested object.

Here is what the modified result will look like in the console:

```md
"John"
30
"123 Main St"
"Anytown"
"CA"
```

A `for...in` loop is useful when you need to loop over the properties of an object.

It is not recommended to use a `for...in` loop to loop over the elements of an array. Instead, use a `for...of` loop or other array methods like `forEach`, `map`, `filter`, and `reduce`, which you will learn about in future lessons.

# --questions--

## --text--

What will be the output of the following code?

```js
const fruit = {
  name: 'apple',
  color: 'red',
  price: 0.99
};

for (const prop in fruit) {
  console.log(fruit[prop]);
}
```

## --answers--

```md
apple
apple
apple
```

### --feedback--

Review the beginning of the lesson to learn what the `for...in` loop does.

---

```md
name
color
price
```

### --feedback--

Review the beginning of the lesson to learn what the `for...in` loop does.

---

```md
apple
red
0.99
```

---

```md
fruit
fruit
fruit
```

### --feedback--

Review the beginning of the lesson to learn what the `for...in` loop does.

## --video-solution--

3

## --text--

Why is it generally not recommended to use a `for...in` loop to iterate over the elements of an array?

## --answers--

`for...in` only iterates over array methods, not elements.

### --feedback--

Consider the types of properties and indices `for...in` can access.

---

`for...in` iterates over all enumerable properties, including inherited properties and non-numeric properties, which may lead to unexpected results.

---

`for...in` loops are slower compared to other array iteration methods.

### --feedback--

Consider the types of properties and indices `for...in` can access.

---

`for...in` cannot handle arrays with non-numeric indices.

### --feedback--

Consider the types of properties and indices `for...in` can access.

## --video-solution--

2

## --text--

Why is the `isObject` function necessary in the nested loop example?

## --answers--

To check if the value is a string.

### --feedback--

Think about the additional checks needed to check if the value is an object literal.

---

To ensure that the value is neither an array nor `null`.

---

To verify that the value is an integer.

### --feedback--

Think about the additional checks needed to check if the value is an object literal.

---

To convert the value to an object.

### --feedback--

Think about the additional checks needed to check if the value is an object literal.

## --video-solution--

2
