---
id: 67329f7f3d1bd75c17896c66
title: How Do Loops and Iteration Work in JavaScript?
challengeType: 19
dashedName: how-do-loops-and-iteration-work-in-javascript
---

# --interactive--

Loops in programming are used to repeat a block of code multiple times.

An example of a loop would be when you are designing a program that needs to print out a list of items. You could use a loop to print out each one of the items in the list.

Another example would be when you are designing a game and you want to move a character across the screen. You could use a loop to move the character a certain number of pixels each time the loop runs. 

In JavaScript, there are several types of loops that you can use. In this lesson, we will cover the `for` loop. Here is the basic syntax for a `for` loop:

```js
for (initialization; condition; increment or decrement) {
  // code block to be executed
}
```

The initialization statement is executed before the loop starts. It is typically used to initialize a counter variable. A counter variable is a variable that is used to keep track of how many times the loop has run.

The condition statement is evaluated before each iteration of the loop. An iteration is a single pass through the loop.

If the condition is true, the code block inside the loop is executed. If the condition is false, the loop stops and you move on to the next block of code.

The last part of the loop is the increment/decrement statement. This statement is executed after each iteration of the loop. It is typically used to increment or decrement the counter variable.

:::interactive_editor

```js
for (let i = 0; i < 5; i++) {
  console.log(i);
}
```

:::

In the first part of the example above, we initialize a counter variable `i` to `0`. It is common convention to use `i` as the counter variable in a `for` loop.

The next part is to check the condition. In this case, the condition is checking if `i` is less than `5`. Since `i` is `0`, the condition is true, and the code block inside the loop is executed.

The code block inside the loop is to log the value of `i` to the console. The value of `i` is `0`, so the console will show the value of `0`.

Then the increment statement is executed. In this case, we are incrementing `i` by `1`. So `i` is now `1`.

Then we check the condition again which is to check if `i` is less than `5`. Since `i` is now `1`, the condition is still true, and the code block inside the loop is executed again.

We keep repeating this process until the condition is false. In this case, when `i` is `5`, the condition is false, and the loop stops.

When you're working with loops you should be careful not to create a condition that is always true. If you do, the loop will run forever and your program will crash. This is known as an infinite loop.

It is possible to create nested `for` loops. A nested loop is when you place one loop inside of another. We will see examples of when you might want to do this later on.

Loops can be beneficial in programming when you need to repeat a block of code a certain number of times. Even though working with `for` loops can be tricky at first,  with practice you will get the hang of it.

# --questions--

## --text--

What is the purpose of the initialization statement in a `for` loop?

## --answers--

To execute code repeatedly.

### --feedback--

Think about when the loop should start counting at.

---

To check if the loop should continue running.

### --feedback--

Think about when the loop should start counting at.

---

To set up a counter variable before the loop starts.

---

To increment or decrement the counter variable.

### --feedback--

Think about when the loop should start counting at.

## --video-solution--

3

## --text--

What happens if the condition in a `for` loop is always `true`?

## --answers--

The loop will run a limited number of times.

### --feedback--

Think about what an infinite loop is.

---

The loop will run once and then stop.

### --feedback--

Think about what an infinite loop is.

---

The loop will never execute.

### --feedback--

Think about what an infinite loop is.

---

The loop will run forever and may cause the program to crash.

## --video-solution--

4

## --text--

In the following `for` loop example, what will be the output?

```js
for (let i = 2; i <= 6; i += 2) {
  console.log(i);
}
```

## --answers--

`2, 4, 6`

---

`2, 3, 4, 5, 6`

### --feedback--

Pay close attention to the condition and increment statements.

---

`2, 4, 6, 8`

### --feedback--

Pay close attention to the condition and increment statements.

---

`1, 2, 3, 4, 5, 6`

### --feedback--

Pay close attention to the condition and increment statements.

## --video-solution--

1
