---
id: 6839e41fe8dac60f11f583db
title: What Are Ranges and How Can You Use Them in a Loop?
challengeType: 19
dashedName: what-are-ranges-and-how-can-you-use-them-in-a-loop
---

# --description--

The `range()` function is used to generate a sequence of integers. Here is the basic syntax for the `range()` function:

```py
range(start, stop, step)
```

The required `stop` argument is an integer that represents the end point for the sequence of numbers being generated. Here is an example of using the `range()` function:

```py
for num in range(3):
    print(num)
```

The following code generates a sequence of numbers between `0` and `2`. The integer `3` is not included because the `stop` argument is non-inclusive.

If a `start` argument is not specified, then the default is `0`. Otherwise, you can use the optional `start` argument to start the sequence of integers at a integer other than `0`. Here is an example of generating a sequence of integers between `1` and `4`:

```py
for num in range(1, 5):
    print(num)
```

By default the sequence of integers will increment by `1`. But if you want to change that default, then you can use the optional `step` argument. Here is an example of generating a sequence of even integers between `2` and `10`:

```py
for num in range(2, 11, 2):
    print(num)
```

As mentioned earlier, there is only one required argument for the `range()` function. If you don't provide any arguments to `range()`, then you'll get a `TypeError`:

```md
ERROR!
Traceback (most recent call last):
  File "<main.py>", line 1, in <module>
TypeError: range expected at least 1 argument, got 0
```

It is important to note that the `range()` function only accepts integers as arguments, not floats. Remember that floats are numbers with decimal points like `3.4`. If you try to pass floats as arguments, you'll get a `TypeError`:

```md
ERROR!
Traceback (most recent call last):
  File "<main.py>", line 1, in <module>
TypeError: 'float' object cannot be interpreted as an integer
```

If you want to generate a sequence of integers in decrementing order, then you can use a negative integer for the `step` argument, like this:

```py
for num in range(40, 0, -10):
    print(num)
```

The following code prints the numbers `40`, `30`, `20`, and `10` in that order to the console.

Another thing you can do with the `range()` function is create a list of integers by using it with the `list` constructor. The `list` constructor is used to convert an iterable into a list. Here is an example of generating a list of even integers between `2` and `10`:

```py
numbers = list(range(2, 11, 2))
print(numbers) # [2, 4, 6, 8, 10]
```

The `range()` function is a very handy way to generate a sequence of integers in Python. Once you get the hang of it, you'll probably find yourself using it a lot in your Python programs.

# --questions--

## --text--

What is the `range()` function used for?

## --answers--

To generate a list of lists.

### --feedback--

Review the beginning of the lesson for the answer.

---

To generate list of strings.

### --feedback--

Review the beginning of the lesson for the answer.

---

To generate a sequence of integers.

---

To generate a list of characters.

### --feedback--

Review the beginning of the lesson for the answer.

## --video-solution--

3

## --text--

Which of the following is the only required argument needed for the `range()` function?

## --answers--

`stop`

---

`start`

### --feedback--

Review the beginning of the lesson for the answer.

---

`step`

### --feedback--

Review the beginning of the lesson for the answer.

---

`index`

### --feedback--

Review the beginning of the lesson for the answer.

## --video-solution--

1

## --text--

Which of the following errors will be returned from the following code?

```py
range()
```

## --answers--

`IndexError`

### --feedback--

This error occurs when an incompatible type is used for a given operation.

---

`RangeError`

### --feedback--

This error occurs when an incompatible type is used for a given operation.

---

`TypeError`

---

`SyntaxError`

### --feedback--

This error occurs when an incompatible type is used for a given operation.

## --video-solution--

3
