---
id: 6839e3a99ba37f09b9d0059b
title: What Are Tuples and How Do They Work?
challengeType: 19
dashedName: what-are-tuples-and-how-do-they-work
---

# --description--

A tuple is a Python data type used to create an ordered sequence of values. Tuples can contain a mixed set of data types like this:

```py
developer = ('Alice', 34, 'Rust Developer')
```

Tuples are similar to lists, but while lists are a mutable data type, tuples are immutable. This means that the elements in a tuple cannot be changed once it's created.

If you try to update one of the items in the tuple, you will get a `TypeError`:

```py
programming_languages = ('Python', 'Java', 'C++', 'Rust')
programming_languages[0] = 'JavaScript'

"""
Traceback (most recent call last):
  File "<stdin>", line 2, in <module>
TypeError: 'tuple' object does not support item assignment
"""
```

To access an element from a tuple, you can use bracket notation and the index number:

```py
developer = ('Alice', 34, 'Rust Developer')
developer[1] # 34
```

If you need to access elements starting from the end of a tuple, then you can use negative indexing. Here is an example of using a negative index to access the second to last element in a tuple:

```py
numbers = (1, 2, 3, 4, 5)
numbers[-2] # 4
```

If you try to pass in an index number that exceeds or equals the length of the tuple, then you will receive an `IndexError` like this:

```py
numbers = (1, 2, 3, 4, 5)
numbers[7]

"""
Traceback (most recent call last):
  File "<stdin>", line 2, in <module>
IndexError: list index out of range
"""
```

Another way to create a tuple is by using the `tuple()` constructor like this:

```py
developer = 'Jessica'
tuple(developer) # ('J', 'e', 's', 's', 'i', 'c', 'a')
```

For the `tuple()` constructor, you can pass in different iterables like strings, lists and even other tuples. 

To check if an item is in a tuple, you can use the `in` keyword like this:

```py
programming_languages = ('Python', 'Java', 'C++', 'Rust')

'Rust' in programming_languages # True
'JavaScript' in programming_languages # False
```

You can also unpack items from a tuple just like you did with lists:

```py
developer = ('Alice', 34, 'Rust Developer')
name, age, job = developer

print(name) # 'Alice'
print(age) # 34
print(job) # 'Rust Developer'
```

In this example, `name` has the value `'Alice'`, `age` has the value `34`, and `job` has the value `'Rust Developer'`.

If you need to collect any remaining elements from a tuple, you can use the asterisk (`*`) operator like this:

```py
developer = ('Alice', 34, 'Rust Developer')
name, *rest = developer

print(name) # 'Alice'
print(rest) # [34, 'Rust Developer']
```

Here, `name` has the value `'Alice'`, and `rest` is a list comprised of the number `34` and the string `'Rust Developer'`.

Just like with a list, you can use the slice operator on a tuple to extract a portion of it. Here is an example of extracting the items `'pie'` and `'cookies'` into a separate tuple:

```py
desserts = ('cake', 'pie', 'cookies', 'ice cream')
desserts[1:3] # ('pie', 'cookies')
```

Remember that the first number represents the starting index for the extraction while the second number represents the ending index. But note that the item at the ending index is not included in the extracted tuple.

If you need to remove an item from a tuple, that isn't possible because tuples are immutable. So this example, will produce an error:

```py
developer = ('Jane Doe', 23, 'Python Developer')
del developer[1]

"""
Traceback (most recent call last):
  File "<stdin>", line 2, in <module>
TypeError: "tuple" object doesn't support item deletion
"""
```

So when might you use a tuple over a list?

If you need a dynamic collection of elements where you can add, remove and update elements, then you should use a list. If you know that you are working with a fixed and immutable collection of data, then you should use a tuple.

In the next lesson, we will take a look at some common methods you will use when working with tuples.

# --questions--

## --text--

What will be output to the console?

```py
developer = ('Alice', 34, 'Rust Developer')
print(developer[1]) # ?
```

## --answers--

`'Rust Developer'`

### --feedback--

Review the beginning of the lesson for the answer.

---

`IndexError`

### --feedback--

Review the beginning of the lesson for the answer.

---

`34`

---

`'Alice'`

### --feedback--

Review the beginning of the lesson for the answer.

## --video-solution--

3

## --text--

What will be the result for the following code?

```py
desserts = ('cake', 'pie', 'cookies', 'ice cream')
desserts[1:3]
```

## --answers--

`('cookies', 'ice cream')`

### --feedback--

Review the last part of the lesson for the answer.

---

`('cake', 'pie')`

### --feedback--

Review the last part of the lesson for the answer.

---

`('pie', 'cookies')`

---

`('pie', 'ice cream')`

### --feedback--

Review the last part of the lesson for the answer.

## --video-solution--

3

## --text--

What will be the result for the following code?

```py
developer = ("Jane Doe", 23, "Python Developer")
del developer[1]
```

## --answers--

The first item will be deleted. 

### --feedback--

Review the last part of the lesson for the answer.

---

You will get a `TypeError`.

---

You will get an `IndexError`.

### --feedback--

Review the last part of the lesson for the answer.

---

The second item will be deleted.

### --feedback--

Review the last part of the lesson for the answer.

## --video-solution--

2
