---
id: 6839e38cdf93ee5a00c79676
title: What Are Some Common Methods Used for Lists?
challengeType: 19
dashedName: what-are-some-common-methods-used-for-lists
---

# --description--

In the previous lesson, you were introduced to the list data type and learned how to access elements from a list as well as list slicing. In this lesson, you will continue to learn about lists and some common methods associated with them like `append()`, `pop()`, and `sort()`.

The first method we will look at is the `append()` method. This is used to add an item to the end of the list. Here is an example of using the `append()` method to add the number `6` to list of numbers:

```py
numbers = [1, 2, 3, 4, 5]
numbers.append(6)
print(numbers) # [1, 2, 3, 4, 5, 6]
```

If you want to add one list at the end of another, you can also use the `append()` method like this:

```py
numbers = [1, 2, 3, 4, 5]
even_numbers = [6, 8, 10]

numbers.append(even_numbers)
print(numbers) # [1, 2, 3, 4, 5, [6, 8, 10]]
```

Notice how the entire `even_numbers` list is nested inside of the `numbers` list.

But if you want to add all of the individual numbers from the `even_numbers` list at the end of the `numbers` list, then you can use the `extend()` method.

The `extend()` method is similar to the `append()` method, but with `extend()` you can add multiple elements from one list to another. Here's an example of adding the numbers `6`, `8`, and `10` from one list to the end of the `numbers` list:

```py
numbers = [1, 2, 3, 4, 5]
even_numbers = [6, 8, 10]

numbers.extend(even_numbers)
print(numbers) # [1, 2, 3, 4, 5, 6, 8, 10]
```

As you can see, the nested list is gone and it's just a list of numbers.

To insert an element at a specific index in a list, you can use the `insert()` method. This method accepts two arguments: the index where you wish to insert the new item and the item you want to insert.

Here is an example of using the `insert()` method:

```py
numbers = [1, 2, 3, 4, 5]
numbers.insert(2, 2.5)

print(numbers) # [1, 2, 2.5, 3, 4, 5]
```

The following code will insert the number `2.5` at index `2` in the `numbers` list.

If you want to remove an element from a list, you can use the `remove()` method. The `remove()` method takes the value of the element to remove as an argument:

```py
numbers = [10, 20, 30, 40, 50, 50]
numbers.remove(50)

print(numbers) # [10, 20, 30, 40, 50]
```

It is important to note that this method will only remove the first occurrence of an item. Not all of them:

```py
numbers = [10, 20, 30, 40, 50, 50, 50]
numbers.remove(50)

print(numbers) # [10, 20, 30, 40, 50, 50]
```

To remove an element at a specific index in the list, you can use the `pop()` method like this:

```py
numbers = [1, 2, 3, 4, 5]
numbers.pop(1) # The number 2 is returned
```

If you don't specify an element for the `pop` method, then the last element is removed.

```py
numbers = [1, 2, 3, 4, 5]
numbers.pop() # The number 5 is returned
```

If you need to empty the list, then you can use the `clear()` method like this:

```py
numbers = [1, 2, 3, 4, 5]
numbers.clear()

print(numbers) # []
```

The next method we will take a look at is the `sort()` method. This method is used to sort the elements in place. Here is an example of sorting a random list of numbers in place:

```py
numbers = [19, 2, 35, 1, 67, 41]
numbers.sort()

print(numbers) # [1, 2, 19, 35, 41, 67]
```

In contrast to the `sort()` method, there is the `sorted()` function which works for any iterable and returns a new sorted list instead of modifying the original list. For example:

```py
numbers = [19, 2, 35, 1, 67, 41]
sorted_numbers = sorted(numbers)

print(numbers) # [19, 2, 35, 1, 67, 41]
print(sorted_numbers) # [1, 2, 19, 35, 41, 67]
```

As a reminder, an iterable is a special type of object that you can loop over, allowing you to access each item one at a time. You'll learn more about how loops work in Python in a future lesson.

Both the `sort()` method and `sorted()` function accept optional `key` and `reverse` parameters. You will learn more about these optional parameters in a future lesson when you learn about tuples. You'll also learn more about other built-in functions like `sorted()` in future lessons.

The next method we will take a look at is the `reverse()` method. This method, will reverse a list of elements in place like this:

```py
numbers = [6, 5, 4, 3, 2, 1]
numbers.reverse()

print(numbers) # [1, 2, 3, 4, 5, 6]
```

The last method we will take a look at is the `index` method. This is used to find the first index where an element can be found in a list. Here is an example of using the `index` method to find the language `'Java'` in a `programming_languages` list:

```py
programming_languages = ['Rust', 'Java', 'Python', 'C++']
programming_languages.index('Java') # 1
```

If the element cannot be found, then Python throws a `ValueError`:

```py
programming_languages = ['Rust', 'Java', 'Python', 'C++']
programming_languages.index('JavaScript')

"""
Traceback (most recent call last):
  File "<stdin>", line 1, in <module>
ValueError: 'JavaScript' is not in list
"""
```

There are a few more methods for Python lists, but this initial list of methods is a good place to start.

# --questions--

## --text--

Which of the following examples will correctly insert the number 2.5 at index 2 in the numbers list?

## --answers--

```py
numbers = [1, 2, 3, 4, 5]
numbers.insertInto(2.5, 2)
```

### --feedback--

Remember that the first index represent the index where you want to insert into and the second index represents the item you want to insert.

---

```py
numbers = [1, 2, 3, 4, 5]
numbers.insert(2, 2.5)
```

---

```py
numbers = [1, 2, 3, 4, 5]
numbers.insertInto(2, 2.5)
```

### --feedback--

Remember that the first index represent the index where you want to insert into and the second index represents the item you want to insert.

---

```py
numbers = [1, 2, 3, 4, 5]
numbers.insert(2.5, 2)
```

### --feedback--

Remember that the first index represent the index where you want to insert into and the second index represents the item you want to insert.

## --video-solution--

2

## --text--

Which of the following methods will reverse a list of elements in place?

## --answers--

`reverse()`

---

`reversing()`

### --feedback--

Review the last part of the lesson for the answer.

---

`reversedList()`

### --feedback--

Review the last part of the lesson for the answer.

---

`reversingList()`

### --feedback--

Review the last part of the lesson for the answer.

## --video-solution--

1

## --text--

Which of the following is **NOT** a list method?

## --answers--

`pop()`

### --feedback--

One of these methods is used in JavaScript. Not Python.

---

`clear()`

### --feedback--

One of these methods is used in JavaScript. Not Python.

---

`splice()`

---

`append()`

### --feedback--

One of these methods is used in JavaScript. Not Python.

## --video-solution--

3
