---
id: 67fe8399c41a212871025f96
title: What Are Lists and How Do They Work?
challengeType: 19
dashedName: what-are-lists-and-how-do-they-work
---

# --description--

Over the next few lessons we are going to learn about lists, tuples, and ranges, which are three basic sequence types used in Python.

The list data type is an ordered sequence of elements that can be comprised of strings, numbers, or even other lists. Lists are mutable and use zero-based indexing, meaning that the first element of the list is at index zero.

Here is the basic syntax for a list:

```py
cities = ['Los Angeles', 'London', 'Tokyo']
```

To access an element from the `cities` list, you can reference its index number in the sequence. Here is an example of accessing the first element of the `cities` list:

```py
cities = ['Los Angeles', 'London', 'Tokyo']
cities[0] # 'Los Angeles'
```

Negative indexing is used to access elements starting from the end of the list instead of the beginning at index `0`. To access the last element of any list, you can use `-1` like this:

```py
cities = ['Los Angeles', 'London', 'Tokyo']
cities[-1] # 'Tokyo'
```

Another way to create a list is to use the `list()` constructor. The `list()` constructor is used to convert an iterable into a list like this:

```py
developer = 'Jessica'
list(developer) # ['J', 'e', 's', 's', 'i', 'c', 'a']
```

An iterable is a special type of object that can be looped over one item at a time. You will learn more about loops in Python later on.

To get the total number of elements in a list, you can use the `len()` function like this:

```py
numbers = [1, 2, 3, 4, 5]
len(numbers) # 5
```

If you wanted to update a value at a particular index, you can do something like this:

```py
programming_languages = ['Python', 'Java', 'C++', 'Rust']
programming_languages[0] = 'JavaScript'
print(programming_languages) # ['JavaScript', 'Java', 'C++', 'Rust']
```

Since lists are mutable, you can update any element in the list as long as you pass in a valid index number. If you pass in an index (either positive or negative) that is out of bounds for the list, then you will receive an `IndexError`:

```py
programming_languages = ['Python', 'Java', 'C++', 'Rust']
programming_languages[10] = 'JavaScript'

"""
Traceback (most recent call last):
  File "<stdin>", line 2, in <module>
IndexError: list assignment index out of range
"""
```

If you want to remove an element from a list you can use the `del` keyword like this:

```py
developer = ['Jane Doe', 23, 'Python Developer']
del developer[1]
print(developer) # ['Jane Doe', 'Python Developer']
```

Sometimes it is helpful to check if an element is inside the list. To do that, you can use the `in` keyword like this:

```py
programming_languages = ['Python', 'Java', 'C++', 'Rust']

'Rust' in programming_languages # True
'JavaScript' in programming_languages # False
```

Sometimes it is common to have lists nested inside of other lists like this:

```py
developer = ['Alice', 25, ['Python', 'Rust', 'C++']]
```

In this example, we have one nested list containing three popular programming languages. To access the nested list, you will need to access it using index `2` since lists are zero based indexed:

```py
developer = ['Alice', 25, ['Python', 'Rust', 'C++']]
developer[2] # ['Python', 'Rust', 'C++']
```

Then to access the second language from that nested list, you will need to access it using index `1` like this:

```py
developer = ['Alice', 25, ['Python', 'Rust', 'C++']]
developer[2][1] # 'Rust'
```

Another common technique used with lists is unpacking values.

Unpacking values from a list is a technique used to assign values from a list to new variables. Here is an example of unpacking a `developer` list into new variables called `name`, `age` and `job`. 

```py
developer = ['Alice', 34, 'Rust Developer']
name, age, job = developer

print(name) # 'Alice'
print(age) # 34
print(job) # 'Rust Developer'
```

Here, `name` has the value `'Alice'`, `age` has the value `34`, and `job` has the value `'Rust Developer'`.

If you need to collect any remaining elements from a list, you can use the asterisk (`*`) operator like this:

```py
developer = ['Alice', 34, 'Rust Developer']
name, *rest = developer

print(name) # 'Alice'
print(rest) # [34, 'Rust Developer']
```

In this example, `name` will still have the value `'Alice'`, and `rest` is a list of two items: the number `34` and the string `'Rust Developer'`.

If the numbers of variables on the left side of the assignment operator doesn't match the total numbers of items in the list, then you will receive a `ValueError`:

```py
developer = ['Alice', 34, 'Rust Developer']
name, age, job, city = developer

"""
Traceback (most recent call last):
  File "<stdin>", line 2, in <module>
ValueError: not enough values to unpack (expected 4, got 3)
"""
```

The last concept we will look at is the slice operator (`:`). Similar to strings, you can access portions of a list by using the slice operator like this:

```py
desserts = ['Cake', 'Cookies', 'Ice Cream', 'Pie', 'Brownies']
desserts[1:4] # ['Cookies', 'Ice Cream', 'Pie']
```

In this example, the start index is `1` since that points to the second item in the list. Then we use the slice operator followed by an end index of `4`, which includes everything up to (but not including), the item at that index.

Another thing you can do with the slice operator `:` is specify a step interval which determines how much to increment between the indices. Let's say you had a list of numbers like this:

```py
numbers = [1, 2, 3, 4, 5, 6]
```

If you wanted to extract a list of just even numbers, you can use the slicing operator like this:

```py
numbers = [1, 2, 3, 4, 5, 6]
numbers[1::2] # [2, 4, 6]
```

The first even number is at index `1`, so that will be the start index. Since we want to go through the end of the list, then we omit the end index. Lastly, we specify `2` for the optional step interval so it will only increment by `2` instead of the default `1`.

Lists are a useful and flexible data structure that you will use a lot in your Python programs. In the next lesson, you will learn about common methods that you can use with lists.

# --questions--

## --text--

Which of the following is true about lists?

## --answers--

They are two-based indexed.

### --feedback--

Refer to the beginning of the lesson for the answer.

---

They are zero-based indexed.

---

They are only used inside of classes. 

### --feedback--

Refer to the beginning of the lesson for the answer.

---

They are rarely used in Python programs.

### --feedback--

Refer to the beginning of the lesson for the answer.

## --video-solution--

2

## --text--

Which of the following is the correct way to access the second element in the list?

```py
cities = ['Los Angeles', 'London', 'Tokyo']
```

## --answers--

`cities[1]`

---

`cities[2]`

### --feedback--

Refer to the beginning of the lesson for the answer.

---

`cities[0]`

### --feedback--

Refer to the beginning of the lesson for the answer.

---

`cities[-1]`

### --feedback--

Refer to the beginning of the lesson for the answer.

## --video-solution--

1

## --text--

Which of the following is the correct way to access the second element from the end?

```py
numbers = [1, 2, 3, 4, 5, 6]
```

## --answers--

`numbers[-5]`

### --feedback--

Remember that negative indexing is used to access elements starting at the end.

---

`numbers[2]`

### --feedback--

Remember that negative indexing is used to access elements starting at the end.

---

`numbers[0]`

### --feedback--

Remember that negative indexing is used to access elements starting at the end.

---

`numbers[-2]`

## --video-solution--

4
