---
id: 6716744f7245947a3dd60009
title: What Are the Different Target Attribute Types, and How Do They Work?
challengeType: 19
dashedName: what-are-the-different-target-attribute-types
---

# --interactive--

You may have seen the `target` attribute on anchor elements, or links. This important attribute tells the browser where to open the URL for the anchor element.

Enable the interactive editor, click on the link and you will be directed to the freeCodeCamp homepage in a new browser tab.

:::interactive_editor

```html
<a href="https://freecodecamp.org" target="_blank">Visit freeCodeCamp</a>
```

:::

There are four important possible values for this attribute. Note that each value is preceded by an underscore.

The first value is `_self`, which is the default value. This opens the link in the current browsing context. In most cases, this will be the current tab or window.

The second value is `_blank`, which opens the link in a new browsing context. Typically, this will open in a new tab. But some users might configure their browsers to open a new window instead.

The third value is `_parent`, which opens the link in the parent of the current context. For example, if your website has an `iframe`, a `_parent` value in that `iframe` would open in your website's tab/window, not in the embedded frame.

The fourth value is `_top`, which opens the link in the top-most browsing context - think "the parent of the parent". This is similar to `_parent`, but the link will always open in the full browser tab/window, even for nested embedded frames.

There is a fifth value, called `_unfencedTop`, which is currently used for the experimental FencedFrame API. At the time of this lesson, you probably won't have a reason to use this one yet.

Selecting the right `target` value to control where your users end up is an important consideration when creating a website. 

# --questions--

## --text--

How many current `target` values are there to choose from?

## --answers--

2

### --feedback--

Don't include the experimental `_unfencedTop` attribute.

---

4

---

3

### --feedback--

Don't include the experimental `_unfencedTop` attribute.

---

1

### --feedback--

Don't include the experimental `_unfencedTop` attribute.

## --video-solution--

2

## --text--

Where will a link with `target="_blank"` open?

## --answers--

In a new window or tab.

---

In the same window or tab.

### --feedback--

You might use this when you don't want someone to lose their place on the current page.

---

On your second monitor.

### --feedback--

You might use this when you don't want someone to lose their place on the current page.

---

On Camperchan's computer.

### --feedback--

You might use this when you don't want someone to lose their place on the current page.

## --video-solution--

1

## --text--

What is the default behavior when you do not set a `target`?

## --answers--

Opens in a new window or tab.

### --feedback--

The default attribute type is `_self`.

---

Opens in the parent context.

### --feedback--

The default attribute type is `_self`.

---

Opens in the same window or tab.

---

Does not open.

### --feedback--

The default attribute type is `_self`.

## --video-solution--

3
