---
id: 6732b79c6aa77826855a3f11
title: How Do JSON.parse() and JSON.stringify() Work?
challengeType: 19
dashedName: how-do-json-parse-and-json-stringify-work
---

# --interactive--

There are two powerful methods in JavaScript for handling JSON data: `JSON.parse()` and `JSON.stringify()`. These methods are commonly used to convert between JSON strings and JavaScript objects.

`JSON.stringify()` is used to convert a JavaScript object into a JSON string. This is useful when you want to store or transmit data in a format that can be easily shared or transferred between systems. 

Here's how you can use the `JSON.stringify()` method:

:::interactive_editor

```js
const user = {
  name: "John",
  age: 30,
  isAdmin: true
};

const jsonString = JSON.stringify(user);
console.log(jsonString);
```

:::

The `JSON.stringify()` method also accepts an optional parameter called a replacer, which can be a function or an array. Here is an example of using an array for the optional replacer parameter:

:::interactive_editor

```js
const developerObj = {
  firstName: "Jessica",
  isAwesome: true,
  isMusician: true,
  country: "USA",
};

// result: {"firstName":"Jessica","country":"USA"}
console.log(JSON.stringify(developerObj, ["firstName", "country"]));
```

:::

In this example, we have a `developerObj` with four properties. When we use the `JSON.stringify()` method, we can pass in an array for the second parameter and specify which properties we want stringified. The result will be a stringified object containing only the `firstName` and `country` properties. 

Another optional parameter for the `JSON.stringify()` method would be the spacer parameter. This allows you to control the spacing for the stringified result:

:::interactive_editor

```js
const developerObj = {
  firstName: "Jessica",
  isAwesome: true,
  isMusician: true,
  country: "USA",
};

console.log(JSON.stringify(developerObj, null, 2));

/* result
{
  "firstName": "Jessica",
  "isAwesome": true,
  "isMusician": true,
  "country": "USA"
}
*/
```

:::

Most of the time you will not be using either of these optional parameters for the `JSON.stringify()` method but it is still helpful to be aware of them. 

Another method you will be using a lot in your programming is the `JSON.parse()` method. `JSON.parse()` converts a JSON string back into a JavaScript object. This is useful when you retrieve JSON data from a web server or from `localStorage` and you need to manipulate the data in your application. You will learn more about `localStorage` in a future lesson. 

Here's an example on how to work with the `JSON.parse()` method:

:::interactive_editor

```js
const jsonString = '{"name":"John","age":30,"isAdmin":true}';
const userObject = JSON.parse(jsonString);
console.log(userObject);

// Result:
// { name: 'John', age: 30, isAdmin: true }
```

:::

This allows you to work with the data in your program as a normal JavaScript object, making it easier to manipulate and use.

In future modules, we will continue to learn more about how to work with JSON and the `JSON.parse()` and `JSON.stringify()` methods.

# --questions--

## --text--

What does `JSON.stringify()` do?

## --answers--

It converts a JSON string into a JavaScript object.

### --feedback--

Think about which function is responsible for creating a string format out of an object.

---

It converts a JavaScript object into a JSON string.

---

It sends data to a web server.

### --feedback--

Think about which function is responsible for creating a string format out of an object.

---

It converts an array into a string.

### --feedback--

Think about which function is responsible for creating a string format out of an object.

## --video-solution--

2

## --text--

What does `JSON.parse()` do?

## --answers--

It converts a JavaScript object into a JSON string.

### --feedback--

This method parses a string and returns a usable JavaScript object.

---

It stores data in local storage.

### --feedback--

This method parses a string and returns a usable JavaScript object.

---

It converts a JSON string into a JavaScript object.

---

It sends data over the network.

### --feedback--

This method parses a string and returns a usable JavaScript object.

## --video-solution--

3

## --text--

Given the following JSON string, how would you convert it back into a JavaScript object and access the `"age"` value?

```js
const jsonString = '{"name":"Alice","age":25}';
```

## --answers--

`jsonString.name`

### --feedback--

Use the method that parses JSON strings into objects and then access the `"age"` property.

---

`JSON.stringify(jsonString).age`

### --feedback--

Use the method that parses JSON strings into objects and then access the `"age"` property.

---

`JSON.parse(jsonString).age`

---

`jsonString[1]`

### --feedback--

Use the method that parses JSON strings into objects and then access the `"age"` property.

## --video-solution--

3
