---
id: 672a511bb408ec81c592eb68
title: How to Use the DOM Inspector and DevTools to Debug and Build Your Projects
challengeType: 19
dashedName: how-to-use-the-dom-inspector-and-devtools
---

# --description--

When you are building out your projects, you will frequently run into issues where your programs are not working as expected.

Programmers often refer to issues as bugs. The process of finding and fixing these bugs is known as debugging.

To debug your code, you will need to use some tools provided by your browser.

Two important tools to use would be the DOM inspector and developer tools.

The DOM inspector allows you to inspect the HTML structure of the page you are on.

The DOM stands for Document Object Model. It is a tree-like structure that represents the elements on a page. You will learn more about the DOM in later modules.

The developer tools allow you to inspect the HTML, CSS, and JavaScript of the page you are on.

Let's take a look at an HTML example that contains a small bug in the anchor element:

```html
<a href="https://www.freecodecamp.org/larn/">freeCodeCamp curriculum</a>
```

When you click on the link, it will lead to a 404 page. A 404 page is an error page that appears when a user tries to access a webpage that doesn't exist on the server.

The intent is for the link to lead to the freeCodeCamp curriculum.

To see what the issue might be, you can use the developer tools.

To open the developer tools in your browser, you can right-click on the page and select `Inspect`.

You can also use `Control Shift I` on your PC keyboard or `Command Option I` on your Mac.

When you open developer tools in Google Chrome, you'll see a number of tabs. The first tab is called the `Elements` tab. This tab shows you the HTML structure of the page you are on.

The second tab is called the `Console` tab. This tab shows you any errors that might be occurring on the page.

In the situation where you have a broken link, you can check the console to see the error messages for that broken link. The common message that continues to display for the broken link is the 404 error. The 404 error indicates that the page is not found.

This lets us know that the issue is with the URL in the anchor element. When you inspect the `href` value you will see there is a typo.

Right now the console message shows `/larn` against a 404, but the correct URL should be `/learn`. When the link is corrected, then it will work as expected.

You will learn more about working with the developer tools throughout the certification, but this is just a short example on how it can help you debug your code.

# --questions--

## --text--

What is the process of finding and fixing bugs in your code called?

## --answers--

Scanning

### --feedback--

Review the beginning of the lesson where this was discussed.

---

Building

### --feedback--

Review the beginning of the lesson where this was discussed.

---

Debugging

---

Scripting

### --feedback--

Review the beginning of the lesson where this was discussed.

## --video-solution--

3

## --text--

What is the tree-like structure that represents the elements on a page called?

## --answers--

BOM

### --feedback--

Review the beginning of the lesson where this was discussed.

---

DOM

---

Python

### --feedback--

Review the beginning of the lesson where this was discussed.

---

CSS

### --feedback--

Review the beginning of the lesson where this was discussed.

## --video-solution--

2

## --text--

What is the role of the "elements" tab in the developer tools?

## --answers--

It shows you the HTML structure of the page you are on.

---

It shows you the CSS structure of the page you are on.

### --feedback--

The name of this tab implies what it is used for.

---

It shows you the JavaScript structure of the page you are on.

### --feedback--

The name of this tab implies what it is used for.

---

It shows you the PHP structure of the page you are on.

### --feedback--

The name of this tab implies what it is used for.

## --video-solution--

1
