---
id: 67336296a3c1591da81856c2
title: What Are Higher-Order Functions?
challengeType: 19
dashedName: what-are-higher-order-functions
---

# --interactive--

Higher order functions are a powerful concept in JavaScript that can significantly enhance your coding abilities and make your code more flexible and reusable.

In essence, a higher order function is a function that either takes one or more functions as arguments, returns a function, or both.

To understand higher order functions, let's first consider functions as first-class citizens in JavaScript. This means that functions can be treated like any other value – they can be assigned to variables, passed as arguments to other functions, and returned from functions. This flexibility is what enables the creation and use of higher order functions.

One common use of higher order functions is to abstract away complex operations.

For example, you might have a function that performs a specific operation on each element of an array. Instead of writing separate functions for different operations, you can create a higher order function that takes the operation as an argument. This allows you to reuse the same function structure with different behaviors.

Here's an example to illustrate this concept:

:::interactive_editor

```js
function operateOnArray(arr, operation) {
  let result = [];
  for (let i = 0; i < arr.length; i++) {
    result.push(operation(arr[i]));
}
  return result;
}

function double(x) {
    return x * 2;
}

let numbers = [1, 2, 3, 4, 5];
let doubledNumbers = operateOnArray(numbers, double);
console.log(doubledNumbers); // [2, 4, 6, 8, 10]
```

:::

In this example, `operateOnArray` is a higher order function. It takes an array and a function (`operation`) as arguments. It then applies the operation to each element of the array. The double function is passed as an argument to `operateOnArray`, demonstrating how functions can be used as values.

Higher order functions can also return functions. This is particularly useful for creating specialized functions based on more general ones. This concept is often referred to as function factories. Here's an example:

:::interactive_editor

```js
function multiplyBy(factor) {
  return function(number) {
    return number * factor;
  }
}

let double = multiplyBy(2);
let triple = multiplyBy(3);

console.log(double(5)); // 10
console.log(triple(5)); // 15
```

:::

In this case, `multiplyBy` is a higher order function that returns a new function. This new function is specialized based on the factor passed to `multiplyBy`. This allows us to create custom multiplication functions with ease.

Higher order functions are not just a theoretical concept – they're widely used in JavaScript.

Many built-in methods for arrays in JavaScript, such as `map()`, `filter()`, and `reduce()`, are higher order functions. These methods take a function as an argument and apply it to the elements of the array in various ways. You will learn more about these methods in future lessons.

The use of higher order functions can lead to more declarative and easier-to-understand code.

Instead of describing step-by-step how to accomplish a task (imperative programming), higher order functions allow you to describe what you want to accomplish (declarative programming). This can make your code more readable and maintainable.

As you continue to work with JavaScript, you'll encounter and use higher order functions frequently. They're a key part of functional programming in JavaScript and are essential for writing clean, efficient, and flexible code.

Understanding and utilizing higher order functions will significantly enhance your ability to write sophisticated and elegant JavaScript programs.

# --questions--

## --text--

Which of the following best describes a higher order function?

## --answers--

A function that only works with numbers.

### --feedback--

Think about what we said regarding how higher order functions interact with other functions.

---

A function that takes a long time to execute.

### --feedback--

Think about what we said regarding how higher order functions interact with other functions.

---

A function that takes another function as an argument or returns a function.

---

A function that can only be called once.

### --feedback--

Think about what we said regarding how higher order functions interact with other functions.

## --video-solution--

3

## --text--

What is a key benefit of using higher order functions?

## --answers--

They always make the code run faster.

### --feedback--

Consider what we mentioned about the ability to reuse function structures with different behaviors.

---

They allow for more flexible and reusable code.

---

They reduce the number of variables needed in a program.

### --feedback--

Consider what we mentioned about the ability to reuse function structures with different behaviors.

---

They eliminate the need for loops in JavaScript

### --feedback--

Consider what we mentioned about the ability to reuse function structures with different behaviors.

## --video-solution--

2

## --text--

In the context of higher order functions, what does it mean for functions to be "first-class citizens" in JavaScript?

## --answers--

Functions are more important than other data types.

### --feedback--

Recall what we said about how functions can be treated in JavaScript.

---

Functions can only be defined at the top level of a program.

### --feedback--

Recall what we said about how functions can be treated in JavaScript.

---

Functions can be treated like any other value, including being passed as arguments.

---

Functions automatically have higher performance than other code.

### --feedback--

Recall what we said about how functions can be treated in JavaScript.

## --video-solution--

3
