---
id: 673284d5e52ef81a2169b097
title: What Are Arrow Functions, and How Do They Work?
challengeType: 19
dashedName: what-are-arrow-functions-and-how-do-they-work
---

# --interactive--

In the previous lesson, you learned how to work with functions, which are reusable pieces of code that help make your code more modular, easier to maintain, and more efficient. All previous examples used the regular function syntax, like this:

```js
function greetings(name) {
  console.log("Hello, " + name + "!");
}
```

But another way to write functions in JavaScript is to create an arrow function expression. Here is how you can refactor the previous example to use arrow function syntax instead:

```js
const greetings = (name) => {
  console.log("Hello, " + name + "!");
};
```

In this revised example, we are creating a `const` variable called `greetings` and assigning it an anonymous function. Most of the syntax will look familiar to you except for the missing `function` keyword and the addition of the arrow (`=>`) between the `name` parameter and the function body. If your parameter list only has one parameter in it, then you can remove the parentheses like this:

```js
const greetings = name => {
  console.log("Hello, " + name + "!");
};
```

If your arrow function has no parameters, then you must use the parentheses like this:

```js
const greetings = () => {
  console.log("Hello");
};
```

When first learning about functions, you had to wrap the function body in curly braces. But if your function body only contains a single line of code, you can remove the curly braces like this:

```js
const greetings = name => console.log("Hello, " + name + "!");
```

It is important to note that removing the parentheses and curly braces for regular function syntax will not work. You will get errors if you tried to do something like this:

```js
// This will produce syntax errors 
function greetings name console.log("Hello, " + name + "!");
```

These types of one line functions only work if you are using the arrow function syntax. Another key concept is the `return` statement. Here is an example of using the arrow function syntax to calculate the area:

:::interactive_editor

```js
const calculateArea = (width, height) => {
  const area = width * height;
  return area;
};

console.log(calculateArea(5, 3)); // 15
```

:::

We are creating a variable inside the function called `area` and then returning that variable. But we could clean up our code a bit and return the calculation itself:

:::interactive_editor

```js
const calculateArea = (width, height) => {
  return width * height;
}; 

console.log(calculateArea(5, 3)); // 15
```

:::

If you tried to remove the curly braces and place the calculation on the same line, then you would get an `Uncaught SyntaxError: Unexpected token 'return'` message:

```js
const calculateArea = (width, height) => return width * height;
```

The reason why you are getting this error, is because you need to remove the `return` statement. When you remove that `return` statement, the error will disappear and the function will still implicitly return the calculation. 

```js
const calculateArea = (width, height) => width * height;
```

So when should you use the arrow function syntax? Well, it depends. Many developers use it consistently in their personal projects. However, when working on a team, the choice usually depends on whether the existing codebase uses regular functions or arrow functions. In future lessons, we'll cover when to use arrow functions and when to avoid them.

# --questions--

## --text--

What is the correct way to write an arrow function that takes two parameters and returns their sum?

## --answers--

`(a, b) => { a + b }`

### --feedback--

Remember the syntax for implicit returns in arrow functions.

---

`(a, b) => a + b`

---

`(a, b) => return a + b`

### --feedback--

Remember the syntax for implicit returns in arrow functions.

---

`a, b => a + b`

### --feedback--

Remember the syntax for implicit returns in arrow functions.

## --video-solution--

2

## --text--

What is the correct way to write an arrow function that takes no parameters and returns the string `"Hello"`?

## --answers--

`() => "Hello"`

---

`=> "Hello"`

### --feedback--

Remember the syntax for arrow functions with no parameters and a single expression return.

---

`() => { "Hello" } `

### --feedback--

Remember the syntax for arrow functions with no parameters and a single expression return.

---

`() => return "Hello"`

### --feedback--

Remember the syntax for arrow functions with no parameters and a single expression return.

## --video-solution--

1

## --text--

What will be the output of the following code?

```js
let multiply = (a, b = 1) => a * b;

console.log(multiply(5));
console.log(multiply(5, 2));
```

## --answers--

`5`, `10`

---

`1`, `2`

### --feedback--

Consider how default parameters work in arrow functions.

---

`undefined`, `10`

### --feedback--

Consider how default parameters work in arrow functions.

---

This will throw an error.

### --feedback--

Consider how default parameters work in arrow functions.

## --video-solution--

1
