---
id: 672ac39a22b0cc30eb8fd65e
title: What Are Best Practices for File/Folder Organization in Web Applications?
challengeType: 19
dashedName: what-are-best-practices-for-file-folder-organization-in-web-applications
---

# --description--

When building out web applications, it is important to think about the organization of your files and folders. This will help keep your code organized and easier to maintain.

Let's take a look at an example folder structure for an HTML and CSS project:

```bash
.
├── /assets
│   ├── /images
│   │   ├── logo.png
│   │   ├── banner.jpg
│   │   └── icons.svg
│   ├── /fonts
│   │   ├── custom-font.woff
│   │   └── custom-font.woff2
├── /css
│   ├── main.css
│   ├── about.css
│   └── contact.css
├── index.html
├── about.html
├── contact.html
└── README.md
```

At the top of the example, there is a single dot, which represents the root directory.

The root directory is the top-level directory in a file system, serving as the starting point for all file paths and containing all other directories and files. A directory is another name for a folder.

Inside the root directory, the first directory shown is the `assets` directory. The term `assets` refers to any files that are used in the project, such as images, fonts, or other resources.

In this example, there are two directories inside the `assets` directory called `images` and `fonts`.

The next directory would be the `css` directory. Sometimes this is also referred to as a stylesheets directory. This is where you would store all of your CSS files.

Below the `css` directory are the HTML files. The `index.html` file represents the homepage, while `about.html` and `contact.html` represent the About and Contact pages, respectively.

Lastly, there is a `README.md` file. `README` files are commonly used to provide useful information about the project, such as what it does, how to use it, and any other relevant details.

The `.md` extension stands for Markdown, which is a lightweight markup language that is often used to write documentation.

By organizing your project into assets, CSS, and HTML files, it makes it easy to find what you are looking for. This also makes it easy for other developers to contribute to your project.

It is important to note that this is just one example of how you can organize your files and folders. There are many different ways to structure a project.

# --questions--

## --text--

What is the assets directory used for in a web application?

## --answers--

It's used to store server log files are kept to monitor web application performance.

### --feedback--

Think about where to store files like images and fonts in a project.

---

It's used to store files such as images, fonts, and other resources.

---

It's used to store scripts and tools for testing the web application.

### --feedback--

Think about where to store files like images and fonts in a project.

---

It's used to hold third-party libraries and frameworks.

### --feedback--

Think about where to store files like images and fonts in a project.

## --video-solution--

2

## --text--

What is a `README.md` file commonly used for in a project?

## --answers--

It's used to store personal information and data collected from users.

### --feedback--

Think about the file that is used to describe the project.

---

It's used to define the structure and schema of the project's database.

### --feedback--

Think about the file that is used to describe the project.

---

It's used to provide useful information about the project.

---

It's used to track and document issues and bugs found in the project.

### --feedback--

Think about the file that is used to describe the project.

## --video-solution--

3

## --text--

What does the root directory represent in a file system?

## --answers--

It represents the default folder where downloaded files are saved.

### --feedback--

Think about the top level directory in a file system.

---

It holds cached files and data to speed up system operations.

### --feedback--

Think about the top level directory in a file system.

---

It contains logs and diagnostic information about system performance.

### --feedback--

Think about the top level directory in a file system.

---

The starting point for all file paths and contains all other directories and files within it.

## --video-solution--

4
