---
id: 6733aafb9c0802f66cc1e056
title: How Does the JavaScript Date Object Work, and What Are Some Common Methods?
challengeType: 19
dashedName: how-does-the-javascript-data-object-work-and-what-are-some-common-methods
---

# --interactive--

Dates and times in JavaScript have not always been easy to work with. In a professional codebase, you will probably be using a library that has solved a lot of those issues for you.

But there will be times where you will need to work JavaScript's built-in `Date` object.

In this lesson, we will go over the basics of the `Date` object and some of the most common methods that you will use when working with dates and times in JavaScript.

The `Date` object is a built-in object in JavaScript that allows you to work with dates and times. Here is the basic syntax for creating a new `Date` object:

```js
const now = new Date();
```

The `new` keyword is used to create a new instance of the `Date` object, and the `Date` object is then assigned to the variable `now`. If you were to log the value of `now` to the console, you would see the current date and time based on the system clock of the computer running the code.

Here is an example response you would see if you logged the value of `now` to the console:

:::interactive_editor

```js
const now = new Date();
console.log(now);
```

:::

For the time, it is using the military time format, so `14:30` is `2:30 PM`. `GMT-0700` is the timezone offset, and `Pacific Daylight Time` is the timezone name.

You can also pass in a specific date and time to the `Date` object by providing the year, month, day, hour, minute, second, and millisecond values as arguments.

Here is an example of creating a new `Date` object with a specific date and time:

:::interactive_editor

```js
const specificDate = new Date("July 4, 1776 12:00:00");

console.log(specificDate);
```

:::

This is useful when you need to work with a specific date and time rather than the current date and time. The input always needs to be a string, and the format should be recognizable by the `Date` object.

To get the current date and time, you can use the `Date.now()` method, which returns the number of milliseconds since `January 1, 1970, 00:00:00 UTC`. This is known as the Unix epoch time.

Unix epoch time is a common way to represent dates and times in computer systems because it is an integer that can be easily stored and manipulated. UTC stands for Universal Time Coordinated, which is the primary time standard by which the world regulates clocks and time.

If you need to get a day of the month based on the current date, you can use the `getDate` method. Here is an example of using the `getDate` method:

:::interactive_editor

```js
const now = new Date();
const date = now.getDate();
console.log(date); 
```

:::

In this example, we create a new date instance using the `Date` object and assign it to the variable `now`. We then call the `getDate` method on the `now` object to get the day of the month and assign it to the variable `date`. Finally, we log the value of `date` to the console, which will output the current day of the month.

`getDate` will return an integer value between `1` and `31`, depending on the day of the month. If the date is invalid, it will return `NaN` (Not a Number).

To get the month, you can use the `getMonth` method like this:

:::interactive_editor

```js
const now = new Date();
const month = now.getMonth();
console.log(month);
```

:::

The month is zero-based, so `January` is `0`, `February` is `1`, and so on. If the month is invalid, it will return `NaN`.

If you need to get the full year, then you can use the `getFullYear` method like this:

:::interactive_editor

```js
const now = new Date();
const year = now.getFullYear();
console.log(year); 
```

:::

If the year is invalid, it will return `NaN`.

There are many more methods available on the `Date` object including `getHours`, `getMinutes`, `getSeconds`, and so on. I encourage you to explore some more on your own through Mozilla's documentation or other resources.

# --questions--

## --text--

What does the `Date.now()` method return?

## --answers--

The current date in string format.

### --feedback--

This method provides a way to get the current time in a format that's often used in computing.

---

The number of milliseconds since January 1, 1970, 00:00:00 UTC.

---

The current day of the month.

### --feedback--

This method provides a way to get the current time in a format that's often used in computing.

---

The full year of the current date.

### --feedback--

This method provides a way to get the current time in a format that's often used in computing.

## --video-solution--

2

## --text--

If you use the `getMonth` method and it returns `4`, which month is being represented?

## --answers--

`May`

---

`April`

### --feedback--

Remember that months are zero-based in JavaScript.

---

`June`

### --feedback--

Remember that months are zero-based in JavaScript.

---

`March`

### --feedback--

Remember that months are zero-based in JavaScript.

## --video-solution--

1

## --text--

How would you create a `Date` object for July 4, 1776, at 12:00:00 PM?

## --answers--

`const specificDate = new Date(1776, 6, 4, 12, 0, 0);`

### --feedback--

You can provide the date and time in a string format or as separate numeric values.

---

`const specificDate = new Date("July 4, 1776 12:00:00")`

---

`const specificDate = new Date(1776, 7, 4, 12, 0, 0);`

### --feedback--

You can provide the date and time in a string format or as separate numeric values.

---

`const specificDate = new Date(1776, 6, 4);`

## --video-solution--

2
