---
id: 673500bfe1f41601c1ddb1a2
title: How Do Inline Styles Work in React?
challengeType: 19
dashedName: how-do-inline-styles-work-in-react
---

# --description--

In React, inline styles are used to apply CSS styles directly to React elements within your JSX code instead of defining them in separate CSS files.

React's approach to inline styles involves using JavaScript objects to define styles, rather than traditional CSS strings. This means that instead of writing styles as you would in a CSS file, you create a JavaScript object where the keys are camel cased versions of CSS property names, and the values are the strings of CSS values.

Here is an example of how you can use inline styles for a `Button` component:

```jsx
function Button({ buttonText }) {
  const defaultStyles = {
    backgroundColor: "#007BFF",
    color: "white",
    border: "none",
    borderRadius: "4px",
    padding: "10px 20px",
    fontSize: "16px",
    fontWeight: "bold",
    cursor: "pointer",
    transition: "background-color 0.3s ease",
  };

  return <button style={defaultStyles}>{buttonText}</button>;
}
```

In this example, we define a style object called `defaultStyles`. We then apply these styles to a button element using the `style` attribute. React takes care of applying these styles to the element when it renders.

You can also choose to pass in an object directly to the `style` attribute. Here is what a revised example would look like:

```jsx
function Button({ buttonText }) {
  return (
    <button
      style={{
        backgroundColor: "#007BFF",
        color: "white",
      }}
    >
      {buttonText}
    </button>
  );
}
```

Notice the double curly braces `{{}}` in the `style` attribute. The outer braces indicate a JavaScript expression in JSX, while the inner braces define a JavaScript object literal. This syntax allows you to embed JavaScript objects directly in JSX attributes.

Sometimes you might want to pass in an object directly if there are only a few properties like shown here. Otherwise, passing in a name to an object would be better like in the first example.

It's important to note that while CSS property names are typically written in kebab case, like `font-size`, in React's inline styles, we use camel case, like `fontSize`. This is because the style object is a JavaScript object, and kebab case names are not valid as object keys in JavaScript without using quotes.

A great advantage of inline styles in React is that they support dynamic styling based on a component state or props. For example:

```jsx
function DynamicButton({ isActive }) {
  const buttonStyles = {
    backgroundColor: isActive ? "green" : "red",
    color: "white",
    padding: "10px 15px",
    border: "none",
    cursor: "pointer",
  };

  return <button style={buttonStyles}>Login</button>;
}
```

In this example, the button's background color changes based on the `isActive` prop. This kind of dynamic styling can be powerful for creating interactive and responsive user interfaces.

In summary, inline styles in React provide a powerful way to apply and manipulate styles directly within your components. They use JavaScript objects instead of CSS strings, require camel cased property names, and can easily incorporate dynamic values. They're an essential tool in a React developer's toolkit, especially for creating highly customized and interactive user interfaces.

# --questions--

## --text--

In React inline styles, how should the CSS property `background-color` be written?

## --answers--

`background-color`

### --feedback--

Remember what we said about the naming convention for CSS properties in React inline styles.

---

`backgroundColor`

---

`"background-color"`

### --feedback--

Remember what we said about the naming convention for CSS properties in React inline styles.

---

`background_color`

### --feedback--

Remember what we said about the naming convention for CSS properties in React inline styles.

## --video-solution--

2

## --text--

What is an advantage of using inline styles in React?

## --answers--

They support all CSS features including media queries.

### --feedback--

Think about what we discussed regarding dynamic styling in React components.

---

They are always more performant than external CSS.

### --feedback--

Think about what we discussed regarding dynamic styling in React components.

---

They allow for easy dynamic styling based on component state or props.

---

They are the only way to style React components.

### --feedback--

Think about what we discussed regarding dynamic styling in React components.

## --video-solution--

3

## --text--

How are inline styles applied to a React element?

## --answers--

Using the `class` attribute.

### --feedback--

Recall the syntax we used in our examples for applying styles to React elements.

---

Using the `style` attribute with a JavaScript object.

---

Using a separate CSS file

### --feedback--

Recall the syntax we used in our examples for applying styles to React elements.

---

Using the `css` attribute

### --feedback--

Recall the syntax we used in our examples for applying styles to React elements.

## --video-solution--

2
