---
id: 672bcc8ccc976fd791610f43
title: What Is the CSS Transform Property, and How Does It Work?
challengeType: 19
dashedName: what-is-the-css-transform-property
---

# --interactive--

The CSS `transform` property is a powerful tool that allows you to modify the visual presentation of elements on your webpage without affecting the layout of other elements. It enables you to apply various transformations to elements such as rotating, scaling, skewing, or translating (moving) them in 2D or 3D space.

The `transform` property works by applying a mathematical transformation to an element's coordinate system. This means you can manipulate an element's shape and position while keeping it's original place and document flow intact.

Let's explore some common transform functions. Here's an example of a box element:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="box"></div>
```

```css
body {
  border: 2px solid black;
}

.box {
  width: 200px;
  height: 200px;
  background-color: red;
}
```

:::

We have set the `body` to have a solid black border so that you can see the `.box` element nested inside the `body` element.

The `translate` function moves an element from its current position. Here's an updated example using the `translate` function:  

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="box"></div>
```

```css
body {
  border: 2px solid black;
}

.box {
  width: 200px;
  height: 200px;
  background-color: red;
  transform: translate(50px, 100px);
}
```

:::

This CSS rule will move the element with the class `box` 50 pixels to the right and 100 pixels down from its original position.

The `rotate` function rotates an element around a fixed point and this is an example of using the `rotate` function for the `.box` element from earlier:  

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="box"></div>
```

```css
.box {
  margin: 100px;
  width: 200px;
  height: 200px;
  background-color: red;
  transform: rotate(45deg);
}
```

:::

This will rotate the element forty five degrees clockwise.

The `scale` function allows you to change the size of an element. Here's an example:  

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="box"></div>
```

```css
.box {
  margin: 100px;
  width: 200px;
  height: 200px;
  background-color: red;
  transform: scale(1.5, 2);
}
```

:::

This will make the element one and a half times wider and twice as tall as its original size.

You can combine multiple transformations in a single declaration:  

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="box"></div>
```

```css
.box {
  margin: 100px;
  width: 200px;
  height: 200px;
  background-color: red;
  transform: translate(50px, 50px) rotate(45deg) scale(1.5);
}
```

:::

This will move the element 50 pixels to the right and down, rotate it 45 degrees, and scale it to be one and a half times its original size.

While the `transform` property is powerful for creating visually appealing designs, it's important to consider accessibility when using it. Here are some important accessibility concerns to keep in mind. 

Screen readers may not accurately convey transformed content. For example, if you use `transform` to rearrange the visual order of elements, screen readers will still read the content in the original DOM order. This can lead to confusion for users relying on screen readers.

When using `scale` to resize text be cautious not to make it too small or too large. Extremely small text can be difficult to read while overly large text might overflow its container and become unreadable. It's generally better to use proper font styling techniques for text resizing.

If you are using `transform` for animations effects, be mindful of users who are sensitive to motion. Excessive or rapid animations can cause discomfort or even trigger seizures for some people. Consider providing a way for users to reduce or turn off animations. When using 3D transforms, remember that not all users perceive depth in the same way. Ensure any critical information conveyed through 3D effects is also available in a 2D format or through text.

If you are using `transform` to hide or reveal content, make sure the content is still accessible to screen readers and keyboard navigation. Hidden content should be truly hidden such as by using `display: none;` or `visibility: hidden;`, rather than just being visually moved offscreen. 

When applying `transform` to interactive elements like buttons or links, ensure that the clickable area remains intuitive and easily targetable. A drastically transformed button might be visually confusing or difficult to click especially for users with motor impairments.

In conclusion, while the CSS `transform` property is a powerful tool for creating visually dynamic web designs, it's essential to use it responsibly with accessibility in mind. Always test your transformed elements with various assisted technologies and consider providing alternative ways to access information or functionality that might be affected by transforms.

# --questions--

## --text--

Which of the following is NOT a concern when using CSS transforms in terms of accessibility?

## --answers--

Screen readers may not accurately convey the visual order of transformed elements.

### --feedback--

Think about how transforms affect different types of users, including those using assistive technologies.

---

Transformed text might become too small or too large to read comfortably.

### --feedback--

Think about how transforms affect different types of users, including those using assistive technologies.

---

Transforms always improve the accessibility of a website.

---

Excessive use of transform for animations can cause discomfort for some users.

### --feedback--

Think about how transforms affect different types of users, including those using assistive technologies.

## --video-solution--

3

## --text--

What potential issue should you be aware of when using 3D transforms?

## --answers--

3D transforms always cause websites to load slower.

### --feedback--

Consider how different users might perceive and interact with 3D-transformed content.

---

Not all users perceive depth in the same way, which may affect comprehension.

---

3D transforms are not supported by most modern browsers.

### --feedback--

Consider how different users might perceive and interact with 3D-transformed content.

---

3D transforms automatically make text unreadable.

### --feedback--

Consider how different users might perceive and interact with 3D-transformed content.

## --video-solution--

2

## --text--

When using transform to hide content, what should you ensure for accessibility?

## --answers--

Always use bright colors to make the transformed content stand out.

### --feedback--

Think about how hidden content should behave for users who can't see the visual transformation.

---

Use only 2D transforms for hiding content.

### --feedback--

Think about how hidden content should behave for users who can't see the visual transformation.

---

Make sure the content is still accessible to screen readers and keyboard navigation.

---

Never hide content using transforms.

### --feedback--

Think about how hidden content should behave for users who can't see the visual transformation.

## --video-solution--

3
