---
id: 672aa7e03c2e365e906e5733
title: What Is Overflow in CSS, and How Does It Work?
challengeType: 19
dashedName: what-is-overflow-in-css
---

# --interactive--

Overflow refers to the way elements handle content that exceeds or overflows the size of the containing element. For example, the text content of a `div` element can overflow out of its borders.

Overflow is two-dimensional, the x-axis determines horizontal overflow, and the y-axis determines vertical overflow. 

Let's fix the overflow on our example using the `overflow-y` CSS property. First we can hide the overflow entirely with `hidden` like this: 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
</div>
```

```css
div {
  height: 200px;
  overflow-y: hidden;
}
```

:::

This resolves the overflow problem but now the extra content becomes completely unreachable. Instead we can use scroll to force the element to become scrollable:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
</div>
```
  
```css
div {
  height: 200px;
  overflow-y: scroll;
}
```

:::

Now this turns the container into a scrollable element, allowing all the content to be viewed by scrolling the element independently of the page scroll. We could also let the browser handle it on its own with `auto` value. It's worth noting that vertical scrolling is generally considered okay while horizontal scrolling might be questioned as it's generally not a common design decision.

With this knowledge, you can now control how your content overflows giving you more power over the layout of your pages.

# --questions--

## --text--

What does `overflow` refer to in CSS? 

## --answers--

When an element is positioned outside its parent container.

### --feedback--

The lesson defines `overflow` in relation to content and container size.

---

When content exceeds the size of its containing element.

---

When there are too many elements on a page.

### --feedback--

The lesson defines `overflow` in relation to content and container size.

---

When CSS styles conflict with each other.

### --feedback--

The lesson defines `overflow` in relation to content and container size.

## --video-solution--

2

## --text--

Which CSS property is used to control vertical overflow specifically?

## --answers--

`overflow`

### --feedback--

The lesson mentions a specific property for controlling vertical overflow.

---

`overflow-x`

### --feedback--

The lesson mentions a specific property for controlling vertical overflow.

---

`overflow-y`

---

`vertical-overflow`

### --feedback--

The lesson mentions a specific property for controlling vertical overflow.

## --video-solution--

3

## --text--

According to the lesson, which type of overflow is generally considered more acceptable in web design?

## --answers--

Horizontal overflow.

### --feedback--

The lesson notes a difference in how horizontal and vertical overflow are perceived.

---

Vertical overflow.

---

Both are equally acceptable.

### --feedback--

The lesson notes a difference in how horizontal and vertical overflow are perceived.

---

Neither is acceptable.

### --feedback--

The lesson notes a difference in how horizontal and vertical overflow are perceived.

## --video-solution--

2
