---
id: 6732269a7aa2ca1d6b6574fe
title: What Is the Difference Between an Implicit and Explicit Grid?
challengeType: 19
dashedName: what-is-the-difference-between-an-implicit-and-explicit-grid
---

# --interactive--

Implicit grid refers to the rows and columns automatically created by the browser when placing items in a grid layout – those not explicitly defined using `grid-template-rows` or `grid-template-columns`.

The properties that control the columns and rows created implicitly by the browser are `grid-auto-columns` and `grid-auto-rows`.

Implicit grid also refers to the additional rows and columns the browser automatically generates when you place an item outside the explicitly defined rows and columns.

For instance, let's say you define only two explicit columns in a grid layout this way:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div class="grid-item">Item 1</div>
  <div class="grid-item">Item 2</div>
  <div class="grid-item">Item 3</div>
  <div class="grid-item">Item 4</div>
  <div class="grid-item">Item 5</div>
  <div class="grid-item">Item 6</div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-columns: 100px 100px; /* Only 2 explicit columns */
}

.grid-item {
  background-color: burlywood;
  border: 1px solid orangered;
  padding: 0.5rem;
  margin: 0.5rem;
}
```

:::

Two items filled the first row using the two explicit columns – `Item 1` in the first column and `Item 2` in the second column.

The next items start a new row with `Item 3` going in the first column of the second row and `Item 4` in the second column of the second row, and so on.

As you've already seen, explicit grids are the areas of the grid you intentionally set up. That is, the rows and columns you explicitly define for a grid layout using the `grid-template-rows` and `grid-template-columns` properties.

Here is a table summarizing the differences between implicit and explicit grids:

| **Feature**          | **Explicit Grid**                                                                  | **Implicit Grid**                                                                          |
|----------------------|------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------|
| **Size control**     | Fully customizable using  ` grid-template-rows `  and  ` grid-template-columns ` . | Controlled by  ` grid-auto-rows `  and  ` grid-auto-columns ` , or defaults to  ` auto ` . |
| **Default Behavior** | Does not change unless explicitly defined.                                         | Automatically adapts to items placed outside the explicit grid.                            |
| **Complexity**       | Requires more planning for layout structure.                                       | Easier to implement for unstructured or variable content.                                  |
| **Flexibility**      | Rigid structure with defined rows and columns.                                     | Flexible and adapts to dynamically placed content.                                         |
| **Performance**      | Potentially more performant as the layout is predefined.                           | May require additional browser computations for implicit grid generation.                  |
| **Use case**         | Useful when the grid structure is predictable and defined upfront.                 | Useful for dynamic layouts where content is unknown or changes frequently.                 |

# --questions--

## --text--

Which properties control the columns and rows created implicitly by the browser in a CSS grid layout?

## --answers--

`cols` and `rows`

### --feedback--

Think about properties that define implicit grid tracks.

---

`col` and `row`

### --feedback--

Think about properties that define implicit grid tracks.

---

`implicit-columns` and `implicit-rows`

### --feedback--

Think about properties that define implicit grid tracks.

---

`grid-auto-columns` and `grid-auto-rows`

## --video-solution--

4

## --text--

Which properties are used to define explicit rows and columns in a CSS grid layout?

## --answers--

`row` and `fr`

### --feedback--

Review the beginning of the lesson where this was discussed.

---

`grid-explicit-rows` and `grid-explicit-columns`

### --feedback--

Review the beginning of the lesson where this was discussed.

---

`grid-template-rows` and `grid-template-columns`

---

`grid-gap` and `grid-flow`

### --feedback--

Review the beginning of the lesson where this was discussed.

## --video-solution--

3

## --text--

Which of the following code examples is the correct way to set two explicit columns?

## --answers--

```css
.grid-container {
   display: grid;
   grid-template-columns: 100px 100px;
}
```

---

```css
.grid-container {
   display: grid;
   grid-template-columns: 100px 100px 100px 100px;
}
```

### --feedback--

Pay close attention to the property name and correct number of values in the examples.

---

```css
.grid-container {
   display: grid;
   grid-template-rows: 100px 100px;
}
```

### --feedback--

Pay close attention to the property name and correct number of values in the examples.

---

```css
.grid-container {
   display: grid;
   grid-column-start: 100px 100px;
}
```

### --feedback--

Pay close attention to the property name and correct number of values in the examples.

## --video-solution--

1
