---
id: 6732267ecab2151ced471cd4
title: How Can You Create Gaps Between Tracks in a Grid?
challengeType: 19
dashedName: how-can-you-create-gaps-between-tracks-in-a-grid
---

# --interactive--

In the previous lessons, we talked a little bit about how to create space between grid items. But in this lesson, we will dive into more detail about how to use the `row-gap`, `column-gap` and `gap` properties in a grid layout.

But first we need to review what a track is in CSS grid. A track is the space between two neighboring grid lines. These lines are automatically created when you use CSS Grid. In this context, tracks generally refer to the rows and columns that make up the grid layout.

To create gaps between columns in a CSS Grid, you can use the `column-gap` property. Acceptable values for this property include pixels, the `em` unit, percentages, or the `normal` keyword.

If you use the `normal` value for the `column-gap` property, then the result will be `0` for grid layouts and `1em` for multi-column layouts.

Here is an example of the markup for a four column grid layout:

```html
<div class="grid-container">
  <div></div>
  <div></div>
  <div></div>
  <div></div>
</div>
```

For the CSS, we set the display to grid and the `column-gap` property to 10 pixels:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div></div>
  <div></div>
  <div></div>
  <div></div>
</div>
```

```css
.grid-container {
  display: grid;
  height: 100px;
  grid-template-columns: 1fr 1fr 1fr 1fr;
  column-gap: 10px;
}

.grid-container div {
  background-color: darkblue;
}
```

:::

If we wanted to change the example to have two rows of blue boxes and create more space between the rows, we can use the `row-gap` property:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div></div>
  <div></div>
  <div></div>
  <div></div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-columns: 1fr 1fr;
  column-gap: 10px;
  row-gap: 30px;
}

.grid-container div {
  height: 100px;
  background-color: darkblue;
}
```

:::

In this revised example, we are setting the `row-gap` property to 30 pixels and changing the `grid-template-columns` to use just two `1fr` units instead of four to create two rows of boxes.

Just like the `column-gap` property, acceptable values for the `row-gap` property can include percentages, `em`, and pixels.

If you want to use a shorthand for creating gaps between rows and columns, you can use the `gap` property. Here is the basic syntax:

```css
gap: row-value optional-column-value;
```

If you specify one value for the `gap` property, then that value will be applied to both rows and columns. If you specify two values, then the first value will go to the row and the second will be applied to the column:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div></div>
  <div></div>
  <div></div>
  <div></div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 30px 10px;
}

.grid-container div {
  height: 100px;
  background-color: darkblue;
}
```

:::

Acceptable values for the `gap` shorthand property include percentages, pixels, `em` and even `calc()` values. But you cannot use `fr` units here.

The `row-gap`, `column-gap`, and `gap` properties provide flexible ways to control spacing between items in a CSS Grid layout. By using these properties, you can easily create visually appealing grids with consistent and adjustable gaps between rows and columns.

# --questions--

## --text--

What is the purpose of the `column-gap` property in a CSS Grid layout?

## --answers--

It sets the space between grid columns

---

It defines the size of the grid items

### --feedback--

Think about the spacing for columns here.

---

It defines the number of columns in the grid.

### --feedback--

Think about the spacing for columns here.

---

It sets the space between grid rows.

### --feedback--

Think about the spacing for columns here.

## --video-solution--

1

## --text--

What happens if you use the `normal` value for the `column-gap` property under a grid layout?

## --answers--

The `gap` between columns is set to 10

### --feedback--

Review the beginning of the lesson where this was discussed.

---

The `gap` between columns is set to -1

### --feedback--

Review the beginning of the lesson where this was discussed.

---

The `gap` between columns is set to 14

### --feedback--

Review the beginning of the lesson where this was discussed.

---

The `gap` between columns is set to 0

## --video-solution--

4

## --text--

Which of the following is the correct property used as a shorthand for creating gaps between rows and columns?

## --answers--

`gapsAndSpaces` property

### --feedback--

Review the end of the lesson where the correct property is discussed.

---

`space` property

### --feedback--

Review the end of the lesson where the correct property is discussed.

---

`rowGapColumnGap` property

### --feedback--

Review the end of the lesson where the correct property is discussed.

---

`gap` property

## --video-solution--

4
