---
id: 673226732b19aa1cacd0a75c
title: How Can You Create Flexible Grids with the fr Unit?
challengeType: 19
dashedName: how-can-you-create-flexible-grids-with-the-fr-unit
---

# --interactive--

In the previous lesson, you were introduced to CSS grid which can be used to create complex and fluid layouts in your web pages. In this lesson, we will explore how to create flexible grid layouts using the `fr` unit.

Let's start with this HTML markup which is going to represent our grid container:

```html
<div class="grid-container">
  <div class="col"></div>
  <div class="col"></div>
  <div class="col"></div>
  <div class="col"></div>
</div>
```

Inside the CSS, we set the display property to grid for the container.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="grid-container">
  <div class="col"></div>
  <div class="col"></div>
  <div class="col"></div>
  <div class="col"></div>
</div>
```

```css
html,
body {
  width: 90%;
  height: 50%;
}

.grid-container {
  display: grid;
  grid-template-columns: 25% 25% 25% 25%;
  gap: 15px;
  background-color: darkgray;
  height: 100%;
}

.col {
  background-color: darkslateblue;
}
```

:::

`grid-template-columns` is used to set the size for each column. In this case, each column size will be `25%` of the container. Then the gap property is used to create space around each column.

So far we have been using percentages for the column size but we can also use the `fr` unit.

The `fr` unit is a fractional unit which represents a fraction of the space for the grid container.

Here is what the code will look like when it is refactored to use `fr` units instead of percentages.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="grid-container">
  <div class="col"></div>
  <div class="col"></div>
  <div class="col"></div>
  <div class="col"></div>
</div>
```

```css
html,
body {
  width: 90%;
  height: 50%;
}

.grid-container {
  display: grid;
  grid-template-columns: 1fr 1fr 1fr 1fr;
  gap: 15px;
  background-color: darkgray;
  height: 100%;
}

.col {
  background-color: darkslateblue;
}
```

:::

Each column will take up one fraction of the available space. Since there are four columns, each column will have an equal share of the space available in the grid container.

As you start to build your grid layouts, you will find yourself wanting to use `fr` units more often because they provide a flexible, proportional way to distribute space, allowing you to create responsive layouts that adapt to varying screen sizes without needing to manually adjust pixel values.

# --questions--

## --text--

What is the purpose of the `grid-template-columns` property in a CSS grid container?

## --answers--

It sets the color for the columns.

### --feedback--

Think about how sizes are determined for columns

---

It sets the size for the columns.

---

It sets the gap between the columns.

### --feedback--

Think about how sizes are determined for columns

---

It specifies the number of rows in the grid.

### --feedback--

Think about how sizes are determined for columns

## --video-solution--

2

## --text--

How does the `fr` unit in CSS grid differ from using percentages?

## --answers--

`fr` units create overflow in containers whereas percentages do not.

### --feedback--

Remember that `fr` units allow for proportional distribution of space.

---

`fr` units allocate space based on the available space in the container, whereas percentages take up a percentage of the available space.

---

`fr` units are used for creating flexible layouts whereas percentages are not.

### --feedback--

Remember that `fr` units allow for proportional distribution of space.

---

There is no difference between `fr` units and percentages.

### --feedback--

Remember that `fr` units allow for proportional distribution of space.


## --video-solution--

2

## --text--

What happens when you use `grid-template-columns: 1fr 1fr 1fr 1fr;` in a CSS grid layout?

## --answers--

The container will have four columns, each taking up 10% of the container's width.

### --feedback--

Think about how the space is distributed when using the `fr` unit.

---

The columns will stack vertically.

### --feedback--

Think about how the space is distributed when using the `fr` unit.

---

The columns will be evenly spaced, but their sizes will remain fixed.

### --feedback--

Think about how the space is distributed when using the `fr` unit.

---

The columns will take up equal fractions of the available space, with the size adjusting automatically when the container resizes.

## --video-solution--

4
