---
id: 672aa8ac4631d1623ec5cd86
title: What Is CSS Grid, and How Does It Differ from Flexbox?
challengeType: 19
dashedName: what-is-css-grid
---

# --interactive--

CSS Grid is a powerful layout system that allows web developers to create complex and responsive web page layouts with ease.

Imagine you're arranging furniture in a room – CSS Grid is like having an invisible grid on your floor that helps you position everything precisely where you want it.

When we build websites, we often need to arrange different elements on the page.

Before CSS Grid, this was sometimes tricky, especially for complex layouts. CSS Grid simplifies this process by dividing your web page into rows and columns, creating a grid-like structure.

Let's imagine you were working with a container `div` with several items nested inside like this:

:::interactive_editor

```html
<div class="container">
  <div class="item">Item 1</div>
  <div class="item">Item 2</div>
  <div class="item">Item 3</div>
  <div class="item">Item 4</div>
  <div class="item">Item 5</div>
  <div class="item">Item 6</div>
</div>
```

:::

If you wanted to style those elements in a grid format, you can set the `display` to `grid` and apply columns like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="container">
  <div class="item">Item 1</div>
  <div class="item">Item 2</div>
  <div class="item">Item 3</div>
  <div class="item">Item 4</div>
  <div class="item">Item 5</div>
  <div class="item">Item 6</div>
</div>
```

```css
.container {
  display: grid;
  grid-template-columns: 1fr 1fr 1fr;
  grid-gap: 20px;
}

.item {
  background-color: lightgray;
  padding: 20px;
  text-align: center;
  border: 1px solid #ccc;
}
```

:::

In this code, we're telling the browser to create a grid with three equal-width columns, that's what the `1fr 1fr 1fr` means, and we're adding a 20-pixel gap between each grid item.

Now, you might be wondering: "What about Flexbox? Isn't that also used for layouts?"

You're right! Flexbox is another CSS layout model, and it's quite useful too. But there are some key differences.

Flexbox is one-dimensional, while Grid is two-dimensional. This means Flexbox works great for laying things out in a single row or column, while Grid excels at creating layouts with both rows and columns.

Flexbox is content-first, meaning it adjusts the layout based on the content. Grid, on the other hand, is layout-first, allowing you to create the layout and then place items into it. Grid gives you more precise control over placement. You can tell an item exactly which row and column to occupy.

Here's a Flexbox example for comparison:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="container">
  <div class="item">Item 1</div>
  <div class="item">Item 2</div>
  <div class="item">Item 3</div>
  <div class="item">Item 4</div>
  <div class="item">Item 5</div>
  <div class="item">Item 6</div>
</div>
```

```css
.container {
  display: flex;
  justify-content: space-between;
}
```

:::

This creates a flex container where the items are spaced evenly along the main axis.

Both Grid and Flexbox have their strengths, and often, the best layouts use a combination of both. You might use Grid for the overall page layout, and then use Flexbox for aligning items within each grid area.

In summary, CSS Grid is a powerful tool that allows for precise, two-dimensional layouts. While it might seem complex at first, with practice, it becomes an invaluable tool for creating responsive and complex web layouts.

# --questions--

## --text--

What is the main difference between CSS Grid and Flexbox?

## --answers--

Grid is newer than Flexbox.

### --feedback--

Think about how many directions each layout system primarily works with.

---

Grid is two-dimensional, while Flexbox is one-dimensional.

---

Grid only works with columns, Flexbox only with rows.

### --feedback--

Think about how many directions each layout system primarily works with.

---

Grid is only for desktop layouts, Flexbox for mobile.

### --feedback--

Think about how many directions each layout system primarily works with.

## --video-solution--

2

## --text--

In the CSS Grid example provided, what does `1fr 1fr 1fr` mean in the `grid-template-columns` property?

## --answers--

Create 3 columns, each 1 pixel wide.

### --feedback--

`fr` stands for `fraction`, and it's about dividing available space.

---

Create 3 columns, each taking up one-third of the available space.

---

Create 1 column that's 3 times as wide as the others.

### --feedback--

`fr` stands for `fraction`, and it's about dividing available space.

---

Create a single column divided into 3 equal parts.

### --feedback--

`fr` stands for `fraction`, and it's about dividing available space.

## --video-solution--

2

## --text--

Which statement about CSS Grid is true?

## --answers--

It can only be used for desktop layouts.

### --feedback--

Think about the level of control Grid gives you over item placement.

---

It requires JavaScript to function properly.

### --feedback--

Think about the level of control Grid gives you over item placement.

---

It allows for precise placement of items in both rows and columns.

---

It automatically adjusts layout based on content size.

### --feedback--

Think about the level of control Grid gives you over item placement.

## --video-solution--

3
