---
id: 672bd853c985cdfdeb32f4f9
title: What Is the text-shadow Property, and How Does It Work?
challengeType: 19
dashedName: what-is-the-text-shadow-property
---

# --interactive--

CSS doesn't apply any shadows to the text by default. This is an example of a paragraph without any shadows. But if you do need to add shadows, you can use the `text-shadow` property.

```css
text-shadow: /* Values */
```

In CSS, you can describe a shadow through a combination of its `X` offset, `Y` offset, blur radius, and color. First, you need to specify the `X` and `Y` offset, which represent the horizontal and vertical distance of the shadow from the text, respectively. These values are required.

Here's an example of how to apply an `X` and `Y` offset on a shadow. We apply the `text-shadow` property with an x-offset of `3px` and a y-offset of `2px`:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p>Hello, World!</p>
```

```css
p {
  text-shadow: 3px 2px;
}
```

:::

In the browser, the text and the shadow will look similar but we can also customize the color of the shadow by specifying the value before or after the offset. Let's set the shadow color. We will use a hexadecimal color here but you can use any valid color format. 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p>Hello, World!</p>
```

```css
p {
  text-shadow: 3px 2px #00ffc3;
}
```

:::

We are writing the color after the offset but you can also write the color before the offset if you prefer. It's equivalent:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p>Hello, World!</p>
```

```css
p {
  text-shadow: #00ffc3 3px 2px;
}
```

:::

In the browser, the shadow will have a specific color, so we can distinguish it very easily from the text. Now that we can differentiate the shadow from the text, it's also important to see how positive and negative values affect the shadow offset. Positive values of the `X` offset and `Y` offset will move the shadow right and down, respectively, while negative values will move the shadow left and up. Here's an example that uses negative values instead:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p>Hello, World!</p>
```

```css
p {
  text-shadow: -3px -2px #00ffc3;
}
```

:::

Now the shadow will move left and up in relation to the text. Great. But the shadow is not looking very nice, because it looks exactly like the original text but placed behind it. To make it look nicer, we need to add a third value, the blur radius. This value is optional but makes the shadow look a lot smoother and more subtle. The default value of the radius blur is zero. The higher the value, the bigger the blur, which means that the shadow becomes lighter.

Here, we are setting the blur radius to `3px` and we're back to positive values for the offset:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p>Hello, World!</p>
```

```css
p {
  text-shadow: 3px 2px 3px #00ffc3;
}
```

:::

Now it's starting to look like a shadow. It's more blurry and subtle, so we can focus on the main text while the shadow adds some style in the background. From here, we can tweak the values a little bit until we find a combination of offset, color, and blur radius that fits our needs.

It's also helpful to know that the text can have more than one shadow. You just need to write them in the same `text-shadow` property separated by commas. They will be applied in layers, from front to back, with the first shadow at the top.

Here's an example of a paragraph with three shadows applied in layers. Notice that all these shadows are defined in the same `text-shadow` property and separated by commas:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p>Hello, World!</p>
```

```css
p {
  text-shadow: 
    3px 2px 3px #00ffc3, 
    -3px -2px 3px #0077ff, 
    5px 4px 3px #dee7e5;
}
```

:::

`text-shadow` is a powerful CSS property for making your text stand out. It can also enhance the overall design of your web application. By choosing the offset, blur, and color, you can create a wide range of shadow effects.

# --questions--

## --text--

What is the primary purpose of the `text-shadow` CSS property?

## --answers--

To adjust the font size of text.

### --feedback--

Think about how the `text-shadow` property affects the visual appearance of text.

---

To change the color of text.

### --feedback--

Think about how the `text-shadow` property affects the visual appearance of text.

---

To create a shadow effect for text.

---

To control the spacing between lines of text.

### --feedback--

Think about how the `text-shadow` property affects the visual appearance of text.

## --video-solution--

3

## --text--

How can you create a black text shadow with a horizontal offset to the right and a blur radius of 5 pixels?

## --answers--

`text-shadow: 5px 0px 0px black;`

### --feedback--

Think about the order of the values in the text-shadow property.

---

`text-shadow: 5px 0px 5px black;`

---

`text-shadow: 5px 5px 0px black;`

### --feedback--

Think about the order of the values in the text-shadow property.

---

`text-shadow: 0px 5px 0px black;`

### --feedback--

Think about the order of the values in the text-shadow property.

## --video-solution--

2

## --text--

How can you create a multiple-layered text shadow effect?

## --answers--

By defining multiple shadows in the text-shadow property.

---

By nesting elements within each other.

### --feedback--

Think about how to combine multiple shadow effects.

---

By using the `filter` property.

### --feedback--

Think about how to combine multiple shadow effects.

---

By applying a background image.

### --feedback--

Think about how to combine multiple shadow effects.

## --video-solution--

1
