---
id: 672aa7f7284b235f46f7d4e9
title: What Is CSS Flexbox, and When Should You Use It?
challengeType: 19
dashedName: what-is-css-flexbox
---

# --interactive--

CSS flexbox is a one-dimensional layout model that allows you to arrange elements in rows and columns within a container. You can also control their order and orientation. Web developers use it to create responsive websites and web applications that adapt to different screen sizes and orientations. We refer to flexbox as a one-dimensional layout model because it focuses on arranging elements along a single axis at a time. The axis can be either horizontal or vertical. 

There are two key concepts that you should know about before you start working with flexbox: flex container and flex item.

A flex container is an HTML element with a flex layout. You can arrange and align elements in various ways within a flex container. To make an HTML element a flex container, you need to add `display: flex` to its CSS styles.

Flex items are the direct children of a flex container. These elements can be arranged and aligned within a flex container based on its properties. They can also shrink or expand to fit the available space.

This is an example with a `main` container and three child `div` elements:

```html
<main>
  <div id="first-div"></div>
  <div id="second-div"></div>
  <div id="third-div"></div>
</main>
```

If you set only the `width`, `height`, and `background-color` of these `div` elements in the CSS stylesheet, every child element will be placed on its own row because the container is not flex by default. 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<main>
  <div id="first-div"></div>
  <div id="second-div"></div>
  <div id="third-div"></div>
</main>
```

```css
div {
  width: 80px;
  height: 50px;
}

#first-div {
  background-color: #4d70b2;
}

#second-div {
  background-color: #5c4db2;
}

#third-div {
  background-color: #4da3b2;
}
```

:::

But if you add `display: flex` to the `main` container, the `div` elements will be rearranged to fit on the same row and they will shrink if necessary (to see the previews, enable the interactive editor):

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<main>
  <div id="first-div"></div>
  <div id="second-div"></div>
  <div id="third-div"></div>
</main>
```

```css
main {
  display: flex;
}

div {
  width: 80px;
  height: 50px;
}

#first-div {
  background-color: #4d70b2;
}

#second-div {
  background-color: #5c4db2;
}

#third-div {
  background-color: #4da3b2;
}
```

:::

By default, a flex container will be a block-level element, so the container itself will be on its own row relative to other elements and containers.

Now that you know more about flex containers and flex items, you should also know about flex properties. These properties determine how flex items will be arranged, resized, and distributed within the flex container. Some of the most commonly used ones are `flex-direction`, `justify-content`, `align-items`, and `flex-wrap`.

Great. Now let’s talk a little bit about the flex model. This model defines how flex items are arranged within a flex container. Every flex container has two axes:

- The main axis.
- The cross axis.

The orientation of these axes determines how different properties will affect the layout and distribution of the flex items. By default, the main axis of a flex container is horizontal and the cross axis is vertical. Flex items are arranged in the direction of the main axis. The cross axis is perpendicular to the main axis.

The `flex-direction` property sets the direction of the main axis. The default value of `flex-direction` is `row`, which places all the flex items on the same row, in the direction of your browser's default language (left to right or right to left):

```css
flex-direction: row; /* Default */
```

To reverse the items in the row, you can use `flex-direction: row-reverse`:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<main>
  <div id="first-div"></div>
  <div id="second-div"></div>
  <div id="third-div"></div>
</main>
```

```css
main {
  display: flex;
  flex-direction: row-reverse; 
}

div {
  width: 80px;
  height: 50px;
}

#first-div {
  background-color: #4d70b2;
}

#second-div {
  background-color: #5c4db2;
}

#third-div {
  background-color: #4da3b2;
}
```

:::

This will reverse the order of the flex items. If you want to align the flex items vertically instead, you just need to set `flex-direction` to `column` in the flex container. This will change the direction of the main axis:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<main>
  <div id="first-div"></div>
  <div id="second-div"></div>
  <div id="third-div"></div>
</main>
```

```css
main {
  display: flex;
  flex-direction: column; 
}

div {
  width: 80px;
  height: 50px;
}

#first-div {
  background-color: #4d70b2;
}

#second-div {
  background-color: #5c4db2;
}

#third-div {
  background-color: #4da3b2;
}
```

:::

Now the `div` elements will be aligned vertically because the main axis will be vertical and the cross axis will be horizontal. 

You can also reverse the order of the flex items vertically with `flex-direction: column-reverse`:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<main>
  <div id="first-div"></div>
  <div id="second-div"></div>
  <div id="third-div"></div>
</main>
```

```css
main {
  display: flex;
  flex-direction: column-reverse; 
}

div {
  width: 80px;
  height: 50px;
}

#first-div {
  background-color: #4d70b2;
}

#second-div {
  background-color: #5c4db2;
}

#third-div {
  background-color: #4da3b2;
}
```

:::

CSS flexbox is a powerful layout model that provides a flexible and efficient way to arrange elements within a container. By understanding the key concepts of flex containers, flex items, and the various flex properties, you can create dynamic and responsive websites that adapt to different screen sizes and orientations.

# --questions--

## --text--

What is the primary purpose of CSS Flexbox?

## --answers--

To control the font size of text elements.

### --feedback--

Think about how flexbox is used to arrange and align elements.

---

To create responsive and dynamic layouts.

---

To define the color of elements.

### --feedback--

Think about how flexbox is used to arrange and align elements.

---

To adjust the spacing between elements.

### --feedback--

Think about how flexbox is used to arrange and align elements.

## --video-solution--

2

## --text--

Which of the following CSS properties is used to control the direction in which child elements are arranged within a flex container?

## --answers--

`flex-wrap`

### --feedback--

Think about how the arrangement of elements is determined within a flex container.

---

`align-items`

### --feedback--

Think about how the arrangement of elements is determined within a flex container.

---

`justify-content`

### --feedback--

Think about how the arrangement of elements is determined within a flex container.

---

`flex-direction`

## --video-solution--

4

## --text--

In the flex model, what is the relationship between the main axis and the cross axis?

## --answers--

The main axis is always horizontal, while the cross axis is always vertical.

### --feedback--

Think about the distribution of elements within a flex container.

---

The main axis is always vertical, while the cross axis is always horizontal.

### --feedback--

Think about the distribution of elements within a flex container.

---

The main axis and cross axis are always perpendicular to each other.

---

The main axis and cross axis are always parallel to each other.

### --feedback--

Think about the distribution of elements within a flex container.

## --video-solution--

3
