---
id: 6732720e95f6a0db526a2e4d
title: What Are Binary Logical Operators, and How Do They Work?
challengeType: 19
dashedName: what-are-binary-logical-operators-and-how-do-they-work
---

# --interactive--

Binary logical operators help you evaluate two expressions and return a result based on their truthiness. Let's look at the three most common binary logical operators: logical AND, logical OR, and the nullish coalescing operator.

The logical AND operator is represented by a double ampersand (`&&`). It checks if both operands are true and returns a result. If both operands are truthy, it returns the second value, that is, the one on the right:

:::interactive_editor

```js
const result = true && 'hello';

console.log(result); // hello
```

:::

In the example above, the text `hello` is logged to the console because both operands are `true`. If either operand is falsy, it returns the falsy value:

:::interactive_editor

```js
const result = 0 && 3;

console.log(result); // 0
```

:::

Since `0` is a falsy value, the number `0` is logged to the console. And if both operands are falsy, it returns the first falsy value:

:::interactive_editor

```js
const result = false && 0;

console.log(result); // false
```

:::

Since `false` is a falsy value, then `false` is logged to the console. The logical AND operator is useful when you want to check multiple conditions and ensure that all are true before proceeding. Here is an example:

:::interactive_editor

```js
if (2 < 3 && 3 < 4) {
 console.log('The if block runs'); 
} else {
 console.log('The else block runs');
} 
```

:::

In the condition, since `2` is less than `3` AND `3` is less than `4`, then the sentence `The if block runs` will be logged to the console.

The logical OR operator checks if at least one of the operands is truthy. If the first operand is truthy, it returns that value:

:::interactive_editor

```js
const result = 'This is truthy' || false;

console.log(result); // This is truthy
```

:::

If the first operand is falsy but the second is truthy, the second value will be logged to the console:

:::interactive_editor

```js
const result = 0 || 'This is truthy';

console.log(result); // This is truthy
```

:::

It is common to use the logical OR operator in `if/else` statements like this:

:::interactive_editor

```js
let userInput;

if (userInput || 'Guest') {
 console.log('A user is present');
} else {
 console.log('No user detected');
}
```

:::

Since we didn't assign a value to the `userInput` variable, it is currently `undefined`. The condition in the `if` statement checks if either the `userInput` variable or the string `Guest` are truthy. Since the string `Guest` is true in a boolean context like this, the string `A user is present` will be logged to the console.

The nullish coalescing operator is more sophisticated than logical OR and logical AND. Represented by a double question mark (`??`), it helps in scenarios where you want to return a value only if the first one is `null` or `undefined`. Here is an example of working with the nullish coalescing operator:

:::interactive_editor

```ts
const result = null ?? 'default';

console.log(result); // default
```

:::

Since `null` is a nullish value, the string `default` would be logged to the console. The nullish coalescing operator is incredibly useful in situations where `null` or `undefined` are the only values that should trigger a fallback or default value. Here is an example of dealing with a user's preference settings:


:::interactive_editor

```ts
const userSettings = {
 theme: null,
 volume: 0,
 notifications: false,
};

let theme = userSettings.theme ?? 'light';
console.log(theme); // light
```

:::

In the example above, we have an object called `userSettings` that contains `theme`, `volume` and `notifications` properties. We are accessing the `theme` using dot notation like `userSettings.theme`. You will learn more about how to work with objects in a future lesson. Since the user's `theme` is currently set to `null`, then the string `light` will be logged to the console. 

# --questions--

## --text--

How does the logical AND (`&&`) operator work?

## --answers--

It checks if both operands are `false`.

### --feedback--

Think about when both conditions need to be `true`.

---

It checks if both operands are `true` and returns a result

---

It returns `true` if one operand is `true`.

### --feedback--

Think about when both conditions need to be `true`.

---

It ignores the second operand.

### --feedback--

Think about when both conditions need to be `true`.

## --video-solution--

2

## --text--

What does the nullish coalescing (`??`) operator do?

## --answers--

It returns the first value, regardless of whether it is `null` or `undefined`.

### --feedback--

Think about when you want to provide a fallback value.

---

It returns the second value only if the first is `null` or `undefined`.

---

It checks if both values are equal.

### --feedback--

Think about when you want to provide a fallback value.

---

It compares two values for type coercion.

### --feedback--

Think about when you want to provide a fallback value.

## --video-solution--

2

## --text--

How does the logical OR (`||`) operator work in JavaScript?

## --answers--

It checks if both operands are truthy.

### --feedback--

Think about when you need just one condition to be `true`.

---

It returns `true` only if both operands are `false`.

### --feedback--

Think about when you need just one condition to be `true`.

---

It checks if at least one of the operands is truthy.

---

It returns `true` only if both operands are truthy.

### --feedback--

Think about when you need just one condition to be `true`.

## --video-solution--

3
