---
id: 673271c7581a27d9dd78f6d6
title: What Are Booleans, and How Do They Work with Equality and Inequality Operators?
challengeType: 19
dashedName: what-are-booleans-and-how-do-they-work-with-equality-and-inequality-operators
---

# --interactive--

In an earlier lesson, you were first introduced to the concept of booleans, but in this lesson, we will dive deeper into how booleans work and how the equality and inequality operators work.

Booleans are a data type with only `true` and `false` values. They're useful because they allow you to do something based on some conditions. Booleans are essential when you want to evaluate whether something should happen or not, like deciding if someone can access a certain feature in your app. Here is an example of setting the value `true` to a variable called `isOldEnoughToDrive`:

:::interactive_editor

```js
let isOldEnoughToDrive = true;

console.log(isOldEnoughToDrive); // true
```

:::

You can use this variable inside a conditional like this:

:::interactive_editor

```js
let isOldEnoughToDrive = true;

if (isOldEnoughToDrive) {
 console.log("You're old enough to drive"); // You're old enough to drive
} else {
 console.log("Sorry, you are not old enough to drive");
}
```

:::

A conditional helps you make decisions in your code based on a condition. This example uses what is called an `if/else` statement.

If `isOldEnoughToDrive` is `true`, then the sentence `You're old enough to drive` will be logged to the console. Otherwise, if the `isOldEnoughToDrive` is `false`, then the sentence `Sorry, you are not old enough to drive` will be logged to the console. Since the `isOldEnoughToDrive` variable is set to `true`, the first sentence will be logged to the console. You will learn more about `if/else` statements in a future lesson.

To compare two values, you can use either the equality or strict equality operator. The result of the comparison will be a boolean of either `true` or `false`. Here is an example of using the equality operator to compare a string and a number. The equality operator is represented by a double equals sign (`==`).

:::interactive_editor

```js
console.log(5 == "5"); // true
```

:::

In this example, JavaScript converts the string `"5"` into the number `5` and then checks if they are equal. Since both values are now the same, the result is true. The equality operator uses type coercion before checking if each value is equal.

This differs from the strict equality operator, which does not perform type coercion. The strict equality operator will check if the types are the same and if the values are the same. Here is an example using the strict equality operator to compare a number and string. This operator is represented by a triple equals sign (`===`).

:::interactive_editor

```js
console.log(5 === '5'); // false
```

:::

The following comparison will be `false`, because a string data type is not the same as a number data type. If you need to check if something is not equal to another value, then you can use the inequality or strict inequality operators. Here is an example of using the inequality operator (`!=`) to compare a number with a string. 

:::interactive_editor

```js
console.log(5 != "5"); // false
```

:::

In this example, the result would be `false` because the inequality operator first converts the string value to a number and then compares the values. Since the values would be the same it will return `false`. If you tried to use the strict inequality operator, then you would get a different result. The strict inequality operator is represented by an exclamation mark followed by two equal signs (`!==`).

:::interactive_editor

```js
console.log(5 !== "5"); // true
```

:::

The result would be `true` because the strict inequality operator does not perform any type coercion. Since the number `5` is not equal to the string `"5"`, then the result is `true`.

It is considered best practice to use strict inequality and equality operators whenever possible, as they do not perform type coercion. Most of the time in professional projects, you will see codebases that usually prefer these two operators over the inequality and equality operators.

# --questions--

## --text--

What is the primary use of booleans in JavaScript?

## --answers--

To store numbers and strings.

### --feedback--

Think about values that help determine outcomes in code.

---

To perform arithmetic operations.

### --feedback--

Think about values that help determine outcomes in code.

---

To represent `true` or `false` values and make decisions based on conditions

---

To loop through arrays.

### --feedback--

Think about values that help determine outcomes in code.

## --video-solution--

3

## --text--

Why is it a good idea to use strict equality (`===`) instead of regular equality (`==`) in JavaScript?

## --answers--

It converts data types automatically.

### --feedback--

Think about how strict equality handles data types compared to regular equality.

---

It allows you to compare different types without issues.

### --feedback--

Think about how strict equality handles data types compared to regular equality.

---

It checks both value and type, providing more predictable results.

---

It is faster than regular equality.

### --feedback--

Think about how strict equality handles data types compared to regular equality.

## --video-solution--

3

## --text--

What happens when you use regular equality (`==`) in JavaScript?

## --answers--

It only compares the values without any type conversion.

### --feedback--

Think about how JavaScript handles different types with regular equality.

---

It performs type coercion, converting values to the same type before comparing them.

---

It checks both value and type, like strict equality (`===`).

### --feedback--

Think about how JavaScript handles different types with regular equality.

---

It throws an error if the types don't match.

### --feedback--

Think about how JavaScript handles different types with regular equality.

## --video-solution--

2
