---
id: 6732b284901f8c1539e20bcb
title: How Do You Add and Remove Elements from the Middle of an Array?
challengeType: 19
dashedName: how-do-you-add-remove-elements-from-the-middle-of-an-array
---

# --interactive--

The `splice()` method in JavaScript is a powerful way for modifying arrays. It allows you to add or remove elements from any position in an array, including the middle. The return value for the `splice()` method will be an array of the items removed from the array. If nothing was removed, then an empty array will be returned.

It is important to note that this method will mutate the original array, modifying it in place rather than creating a new array. This is something to be aware of when working with `splice()`. Here is the basic syntax:

```js
array.splice(startIndex, itemsToRemove, item1, item2)
```

`startIndex` specifies the index at which to begin modifying the array, while `itemsToRemove` is an optional parameter indicating how many elements to remove. If `itemsToRemove` is omitted, `splice()` will remove all elements from `startIndex` to the end of the array. The subsequent parameters (`item1`, `item2`, and so on) are the elements to be added to the array, beginning at the start index.

Let's start with an example of removing elements from the middle of an array:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange", "mango", "kiwi"];
let removed = fruits.splice(2, 2);

console.log(fruits);  // ["apple", "banana", "kiwi"]
console.log(removed); // ["orange", "mango"]
```

:::

In this example, `splice(2, 2)` starts at index `2` and removes `2` elements. The modified array will now consist of only `apple`, `banana`, and `kiwi`. Now, let's look at how to add elements to the middle of an array:

:::interactive_editor

```js
let colors = ["red", "green", "blue"];
colors.splice(1, 0, "yellow", "purple");

console.log(colors); // ["red", "yellow", "purple", "green", "blue"]
```

:::

Here, `splice(1, 0, "yellow", "purple")` starts at index `1`, removes `0` elements, and inserts `yellow` and `purple`. The second parameter (`0`) means no elements are removed before insertion. You can also use `splice()` to simultaneously remove and add elements:

:::interactive_editor

```js
let numbers = [1, 2, 3, 4, 5];
numbers.splice(1, 2, 6, 7, 8);

console.log(numbers); // [1, 6, 7, 8, 4, 5]
```

:::

In this case, `splice(1, 2, 6, 7, 8)` starts at index `1`, removes `2` elements (`2` and `3`), and inserts `6`, `7`, and `8`. If you need to keep the original array unchanged, you should create a copy before using `splice()`:

:::interactive_editor

```js
let original = [1, 2, 3, 4, 5];
let copy = [...original];
copy.splice(2, 1, 6);

console.log(original); // [1, 2, 3, 4, 5]
console.log(copy);     // [1, 2, 6, 4, 5]
```

:::

In this example, to create a copy of the `original` array without modifying it, we use the spread operator (`...`). The spread operator will create a shallow copy of the elements of the `original` array into a new array.  You will learn more about this in future lessons.

When we use `copy.splice(2, 1, 6)`, it modifies the copy array by removing the element at index `2` (which is `3`) and inserting the new element `6` at that position.

One common use case for `splice()` is to remove a single element from an array when you know its index:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange", "mango"];
let indexToRemove = fruits.indexOf("orange");
if (indexToRemove !== -1) {
    fruits.splice(indexToRemove, 1);
}

console.log(fruits); // ["apple", "banana", "mango"]
```

:::

In this example, we first use the `indexOf()` method to find the index of the element `orange` in the `fruits` array. The `indexOf()` method returns the index of the first occurrence of the given element or `-1` if the element is not found in the array. 

We then compare `indexToRemove` with `-1` to ensure that the element exists in the array before attempting to remove it. If `indexToRemove` is not equal to `-1` (meaning the element is found), we use `splice()` to remove one element starting from the `indexToRemove` position.

You can also use `splice()` to clear an array by removing all elements:

:::interactive_editor

```js
let array = [1, 2, 3, 4, 5];
array.splice(0);

console.log(array); // []
```

:::

While `splice()` is powerful, it's worth noting that for very large arrays, it can be less efficient than other methods, especially when modifying the beginning of the array. This is because `splice()` may need to shift all subsequent elements. In such cases, if you're only adding or removing elements at the end of the array, methods like `push()`, `pop()`, `unshift()`, and `shift()` might be more appropriate.

In conclusion, the `splice()` method is a versatile way for modifying arrays in JavaScript. It allows for precise control over adding and removing elements from any position in an array. Understanding how to use `splice()` effectively can greatly enhance your ability to manipulate arrays in your JavaScript code.

# --questions--

## --text--

What will be the output of the following code?

```js
let arr = [1, 2, 3, 4, 5];
arr.splice(2, 0, 6, 7);
console.log(arr);
```

## --answers--

`[1, 2, 6, 7, 3, 4, 5]`

---

`[1, 2, 3, 4, 5, 6, 7]`

### --feedback--

Consider what the second parameter (`0`) means in the `splice()` method.

---

`[1, 2, 3, 6, 7, 4, 5]`

### --feedback--

Consider what the second parameter (`0`) means in the `splice()` method.

---

`[1, 2, 6, 7, 4, 5]`

### --feedback--

Consider what the second parameter (`0`) means in the `splice()` method.

## --video-solution--

1

## --text--

Which of the following `splice()` calls would remove the number 3 from the array?

```js
let arr = [1, 2, 3, 4, 5];
```

## --answers--

`arr.splice(3, 1)`

### --feedback--

Remember, array indices start from 0.

---

`arr.splice(3, 0)`

### --feedback--

Remember, array indices start from 0. 

---

`arr.splice(2, 1)`

---

`arr.splice(arr.length - 2, 1)`

### --feedback--

Remember, array indices start from 0.

## --video-solution--

3

## --text--

What does the `splice()` method return?

## --answers--

The modified array.

### --feedback--

Consider what information might be useful to have after removing elements from an array.

---

The number of elements removed.

### --feedback--

Consider what information might be useful to have after removing elements from an array.

---

An array containing the removed elements.

---

`undefined`

### --feedback--

Consider what information might be useful to have after removing elements from an array.

## --video-solution--

3
