---
id: 6733ffc7353af34a61ed683a
title: What Are Cache and Service Workers, and How Do They Work?
challengeType: 19
dashedName: what-are-cache-service-workers-and-how-do-they-work
---

# --description--

Caching is the process of storing copies of files in a temporary storage location so they can be accessed more quickly. 

When you visit a website, your browser can save certain files (such as images, CSS, and JavaScript) locally. This means that the next time you visit the same site, it can load these files from your device instead of fetching them again from a server, making the site load faster.

A service worker is a script that runs in the background, separate from your web page. It can intercept network requests, access the cache, and enable the web app to work offline. It is a key component of Progressive Web Apps.

So, how do cache and service workers work together in Progressive Web Apps?

PWAs are web apps that can offer an app-like experience. They can work offline, send push notifications, and even be installed on the home screen of a mobile device or computer.

When a user first visits a PWA, the service worker can cache important files. 

Users can continue to use the app offline, and when they come back online, any upcoming changes can be synced with the server.

The combination of caching and service workers enables web apps to provide a fast and reliable experience even in poor network conditions.

# --questions--

## --text--

What is the primary purpose of a service worker in a Progressive Web App?

## --answers--

To style web pages.

### --feedback--

Think about what allows PWAs to work offline.

---

To handle server-side logic.

### --feedback--

Think about what allows PWAs to work offline.

---

To intercept network requests and manage caching.

---

To create user interfaces.

### --feedback--

Think about what allows PWAs to work offline.

## --video-solution--

3

## --text--

In the context of PWAs, what does caching primarily help with?

## --answers--

Increasing server capacity.

### --feedback--

Consider how caching affects the loading of web resources.

---

Improving application security.

### --feedback--

Consider how caching affects the loading of web resources.

---

Enhancing offline functionality and speed.

---

Creating backups of user data.

### --feedback--

Consider how caching affects the loading of web resources.

## --video-solution--

3

## --text--

What is a key characteristic of Progressive Web Apps (PWAs)?

## --answers--

They can only be accessed through app stores.

### --feedback--

Think about how PWAs blend features of web and native apps.

---

They require constant internet connection.

### --feedback--

Think about how PWAs blend features of web and native apps.

---

They can work offline and be installed on home screens.

---

They are only available on mobile devices.

### --feedback--

Think about how PWAs blend features of web and native apps.

## --video-solution--

3
