---
id: 6733ff8d06376149474a0c0d
title: What Is the Cache API, and How Does It Work?
challengeType: 19
dashedName: what-is-the-cache-api-and-how-does-that-work
---

# --description--

The `Cache` API is used to store network requests and responses, making web applications work more efficiently and even function offline. It is part of the broader Service Worker API and is critical for creating Progressive Web Apps (PWAs) that can work under unreliable or slow network conditions. 

Before we continue with the `Cache` API, we first need to understand how service workers, PWAs, and network requests work on a basic level. 

A network request is a request made by a web browser or application to a server to retrieve data or resources over the internet. For example, when you visit a website, your browser sends a network request to the web server to get the files (such as HTML, images, or videos) needed to display the page.

A service worker is a special type of JavaScript file that runs in the background of a web application, separate from the main browser thread. It acts as a middleman between the web page and the network, allowing developers to intercept network requests, cache resources, and handle things like push notifications or background sync.

A PWA, or Progressive Web App, is a type of web application that uses modern web technologies to provide a native app-like experience on the web. PWAs are designed to work reliably on any device, regardless of network conditions, and can be accessed through a browser or installed on a user's device like a traditional app. 

Now that we have a better understanding of service workers, PWAs, and network requests, we can dive deeper into the Cache API.

The `Cache` API is a storage mechanism that stores `Request` and `Response` objects. When a request is made to a server, the application can store the response and later retrieve it from the cache instead of making a new network request. This reduces load times, saves bandwidth, and improves the overall user experience.

The browser provides a storage area known as `CacheStorage`, where developers can save key-value pairs of network requests and their corresponding responses.

With the `Cache-Control` header, developers can specify how long a cached resource should remain stored, as well as whether it should be revalidated or served directly from the cache. 

By using the `Cache` API, developers can build offline-first web applications, allowing a PWA, for example, to serve cached assets when the user is disconnected from the network.

# --questions--

## --text--

What is the main purpose of the Cache API in web applications?

## --answers--

To handle user authentication and sessions.

### --feedback--

Think about what the Cache API does in terms of web performance, offline functionality, and caching network requests.

---

To store and manage network requests and responses for offline access.

---

To enable push notifications and background sync.

### --feedback--

Think about what the Cache API does in terms of web performance, offline functionality, and caching network requests.

---

To create and manage service workers.

### --feedback--

Think about what the Cache API does in terms of web performance, offline functionality, and caching network requests.

## --video-solution--

2

## --text--

Which of the following best describes the role of a service worker in a web application?

## --answers--

A background script that handles UI rendering.

### --feedback--

Consider what service workers do to intercept network requests and enable offline behavior in web apps.

---

A tool for managing user authentication and sessions.

### --feedback--

Consider what service workers do to intercept network requests and enable offline behavior in web apps.

---

A special JavaScript file that runs in the background, managing network requests and caching resources.

---

A library for enabling offline data synchronization with a server.

### --feedback--

Consider what service workers do to intercept network requests and enable offline behavior in web apps.

## --video-solution--

3

## --text--

What is a network request in the context of a web application?

## --answers--

A request made by a web browser to retrieve files from a local storage database.

### --feedback--

Think about what happens when a user visits a website and how resources like images, scripts, and data are loaded into the browser.

---

A request made by a web browser or application to a server to retrieve data or resources over the internet.

---

A request made by a web server to push updates to a user's device.

### --feedback--

Think about what happens when a user visits a website and how resources like images, scripts, and data are loaded into the browser.

---

A request made by the server to verify the authentication of a user.

### --feedback--

Think about what happens when a user visits a website and how resources like images, scripts, and data are loaded into the browser.

## --video-solution--

2
