---
id: 6733ff6f02dde548ebe4a6d5
title: What Are Cookies, and How Do They Work?
challengeType: 19
dashedName: what-are-cookies-and-how-do-they-work
---

# --description--

Cookies, also known as web cookies or browser cookies, are small pieces of data that a server sends to a user's web browser. These cookies are stored on the user's device and sent back to the server with subsequent requests. 

Cookies are essential in helping web applications maintain state and remember user information, which is especially important since HTTP is a stateless protocol.

Cookies can store a variety of information such as user preferences, session data, or tracking information.

Cookies are always stored as name-value pairs. This means each cookie has a name (key) and an associated value. 

For example, a cookie might store a user's session ID like this: `sessionId=abc123`. The key is `sessionId`, and the value is `abc123`. Each time the browser communicates with the server, the browser sends these cookies in the form of name-value pairs.

When a user visits a website, the server can send one or more cookies to the user's browser by including a Set-Cookie header in the HTTP response. A header is a key-value pair that provides additional information about the HTTP request or response. You will learn more about HTTP requests and responses in future lessons.

Once the cookies are set, the browser stores them and automatically includes them in the Cookie header with every subsequent request to the same domain. This allows the server to access the stored cookies and use them for things like maintaining user sessions or tracking preferences.

Here’s an example of how a cookie is set in an HTTP response:

```http
Set-Cookie: sessionId=abc123; Expires=Wed, 21 Oct 2021 07:28:00 GMT; Secure; HttpOnly
```

The browser will store the cookie, and in future requests to the same server, it will include the cookie in the `Cookie` header:

```http
Cookie: sessionId=abc123
```

The server can then read the cookie and use the stored session ID to retrieve information about the user, such as whether they are logged in.

Here is a breakdown of the different types of cookies.

- Session Cookies only last for the duration of the user's session on the website. Once the user closes the browser or tab, the session cookie is deleted. These cookies are typically used for tasks like keeping a user logged in during their visit.

- Persistent Cookies have an expiration date and remain stored on the user's device until that date is reached. Persistent cookies are often used for remembering user preferences or login details across sessions.

- Secure Cookies are only sent over HTTPS, ensuring that they cannot be intercepted by an attacker in transit.

- HttpOnly Cookies cannot be accessed or modified by JavaScript running in the browser, making them more secure against cross-site scripting (XSS) attacks. Cross-site scripting (XSS) attacks happen when an attacker injects malicious scripts into a web page that is viewed by other users. These scripts can then execute in the context of the victim's browser, potentially stealing cookies, session data, or performing other malicious actions without the user's knowledge or consent. By marking cookies as HttpOnly, they are protected from being accessed via JavaScript, reducing the risk of such attacks.

You can create cookies via server responses using the `Set-Cookie` header or through JavaScript using `document.cookie`.

Here's an example of setting a cookie using JavaScript:

```js
document.cookie = "username=JohnDoe; expires=Fri, 31 Dec 2021 23:59:59 GMT; path=/";
```

This command sets a cookie named `username` with the value `"JohnDoe"` that will expire at the end of 2021. You can update an existing cookie by simply setting it again with a new value.

To delete a cookie, you set its expiration date in the past:

```js
document.cookie = "username=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/";
```

This will remove the `username` cookie from the browser.

# --questions--

## --text--

What is the primary purpose of cookies in web applications?

## --answers--

To store large amounts of data permanently.

### --feedback--

Think about how cookies help web applications remember user-specific data between requests.

---

To store data that helps maintain state and remembers user information across requests.

---

To replace server-side databases.

### --feedback--

Think about how cookies help web applications remember user-specific data between requests.

---

To enhance JavaScript performance in the browser.

### --feedback--

Think about how cookies help web applications remember user-specific data between requests.

## --video-solution--

2

## --text--

Which of the following attributes ensures that a cookie is only sent over HTTPS?

## --answers--

`Secure`

---

`HttpOnly`

### --feedback--

This attribute protects cookies from being sent over unsecured HTTP connections.

---

`SameSite`

### --feedback--

This attribute protects cookies from being sent over unsecured HTTP connections.

---

`Expires`

### --feedback--

This attribute protects cookies from being sent over unsecured HTTP connections.

## --video-solution--

1

## --text--

How can you delete a cookie using JavaScript?

## --answers--

By setting its value to `null`.

### --feedback--

Think about how setting an expiration date affects the lifespan of a cookie.

---

By setting its expiration date to a past date.

---

By using the `document.cookie.remove()` method.

### --feedback--

Think about how setting an expiration date affects the lifespan of a cookie.

---

By reloading the page.

### --feedback--

Think about how setting an expiration date affects the lifespan of a cookie.

## --video-solution--

2
