---
id: 6733ff5814129c48b4fca88e
title: What Is sessionStorage, and What Are Some Common Methods?
challengeType: 19
dashedName: what-is-sessionstorage-and-what-are-some-common-methods
---

# --description--

In the previous lesson, we learned about working with `localStorage` and were briefly introduced to `sessionStorage`.

Recall, that `sessionStorage` is when the data is cleared as soon as the user closes the tab or window in which the web application is running. It’s ideal for situations where data only needs to persist for the length of a single session, such as maintaining form data during navigation or storing temporary state information during a checkout process.

Much like `localStorage`, `sessionStorage` uses key-value pairs to store and retrieve data. The methods used with `sessionStorage` are also the same as `localStorage`, with the only real difference being how long the data is stored. 

Here are a few examples of working with the different methods:

- `sessionStorage.setItem()`: Stores a key-value pair in `sessionStorage`.

```js
sessionStorage.setItem('cart', '3 items');
```

- `sessionStorage.getItem()`: Retrieves the value of a given key from `sessionStorage`.

```js
let cart = sessionStorage.getItem('cart');
console.log(cart); // Outputs: '3 items'
```

- `sessionStorage.removeItem()`: Removes a specific item from `sessionStorage` using its key.

```js
sessionStorage.removeItem('cart');
```

- `sessionStorage.clear()`: Clears all data stored in `sessionStorage`.

```js
sessionStorage.clear();
```

Let’s look at an example where we store data in `sessionStorage` which only lasts as long as the browser tab or window is open:

```js
// Store data in sessionStorage
sessionStorage.setItem('currentUser', 'JohnDoe');

// Retrieve the stored data
const user = sessionStorage.getItem('currentUser');
console.log(user); // 'JohnDoe'

// Remove a specific key from sessionStorage
sessionStorage.removeItem('currentUser');

// Clear all sessionStorage data
sessionStorage.clear();
```

In this example, we:

1. Store the current user’s name (`JohnDoe`) in `sessionStorage`.

2. Retrieve and display it.

3. Remove the item associated with the key `currentUser`.

4. Clear all `sessionStorage` data.

The key difference from `localStorage` is that as soon as the user closes the tab, all stored session data will be lost.

`sessionStorage` is particularly useful in scenarios like:

- Storing temporary data such as form entries during a multi-page form process.

- Storing temporary selections or preferences that don’t need to persist across sessions.

- Maintaining state on a single-page application that doesn’t need to be remembered once the tab is closed.

`sessionStorage` ensures that once the user leaves the page, the session data is cleared, which is great for scenarios where you don’t want to hold onto information beyond the current session.

# --questions--

## --text--

What happens to the data stored in `sessionStorage` when the browser tab is closed?

## --answers--

The data is permanently stored until manually removed.

### --feedback--

`sessionStorage` only persists for the length of a browser session.

---

The data persists until the computer is turned off.

### --feedback--

`sessionStorage` only persists for the length of a browser session.

---

The data is cleared when the tab or window is closed.

---

The data is synced with `localStorage`.

### --feedback--

`sessionStorage` only persists for the length of a browser session.

## --video-solution--

3

## --text--

Which of the following methods is used to remove a single key-value pair from `sessionStorage`?

## --answers--

`sessionStorage.removeItem()`

---

`sessionStorage.deleteItem()`

### --feedback--

The method name begins with `remove` and affects one specific item.

---

`sessionStorage.clear()`

### --feedback--

The method name begins with `remove` and affects one specific item.

---

`sessionStorage.unset()`

### --feedback--

The method name begins with `remove` and affects one specific item.

## --video-solution--

1

## --text--

In which of the following scenarios would `sessionStorage` be more appropriate than `localStorage`?

## --answers--

Storing user settings like themes that persist across sessions.

### --feedback--

Think about what data only needs to persist for a single session.

---

Storing form data that is only needed during the current browser session.

---

Storing sensitive user information like passwords.

### --feedback--

Think about what data only needs to persist for a single session.

---

Storing data that needs to be shared between different browser windows.

### --feedback--

Think about what data only needs to persist for a single session.

## --video-solution--

2
