---
id: 6733ab64775d35f78f5238fe
title: What Does CRUD Stand For, and How Do the Basic Operations Work?
challengeType: 19
dashedName: what-does-crud-stand-for-and-how-do-the-basic-operations-work
---

# --description--

CRUD is an acronym that stands for Create, Read, Update, and Delete. These are the four operations of persistent storage.

Persistent storage refers to saving data in a way that makes it available even after the power is turned off or the device is restarted.

Understanding how the basic operation of CRUD works is crucial to web development because it forms the foundation for working with databases and building applications where users can add, view, modify, and delete data. 

Now, let’s take a look at each part of CRUD more closely

- Create refers to the process of creating new data. For example, in a web app, this could be when a user adds a new post to a blog.

- Read is the operation where data is retrieved from a database. For instance, when you visit a blog post or view your profile on a website, you’re performing a read operation to fetch and display data stored in the database.

- Update involves modifying existing data in the database. An example would be editing a blog post or updating your profile information.

- Delete is the operation that removes data from a database. For instance, when you delete a blog post or account, you’re performing a delete operation.

CRUD is used when working with databases, the UI, and RESTful APIs. RESTful APIs are a set of conventions for building web services that allow the client to interact with a database or backend system by performing CRUD operations through standard HTTP methods.

HTTP stands for Hypertext Transfer Protocol and it is the foundation for data communication on the web. There are HTTP methods which define the actions that can be performed on resources over the web. The common methods are `GET`, `POST`, `PUT`, `PATCH`, `DELETE`.

You will learn more about RESTful APIs and HTTP in future lessons, but here is a quick break down of how CRUD maps to the different HTTP methods.

- `POST` is used to create a new resource.

- `GET` is used to retrieve or read data.

- `PUT` is used to update a resource by replacing it entirely.

- `PATCH` is used to partially update a resource.

- `DELETE` is used to remove a resource.

Here’s an example of how CRUD operations might be represented in code using a simple array in JavaScript:

```js
let items = [];

// Create
function createItem(item) {
  items.push(item);
}

// Read
function readItems() {
  return items;
}

// Update
function updateItem(index, newItem) {
  items[index] = newItem;
}

// Delete
function deleteItem(index) {
  items.splice(index, 1);
}

// Example Usage
createItem('Book');
console.log(readItems()); // ['Book']
updateItem(0, 'Magazine');
console.log(readItems()); // ['Magazine']
deleteItem(0);
console.log(readItems()); // []
```

In this example:

- We create an item by pushing it into an array.

- We read the items by returning the array.

- We update an item by modifying the array element at a given index.

- We delete an item by removing it from the array using `splice()`.

This is a basic representation of how CRUD operations work at a conceptual level.

# --questions--

## --text--

What does the `C` in CRUD stand for?

## --answers--

`Connect`

### --feedback--

Think about which operation involves adding new data.

---

`Create`

---

`Compile`

### --feedback--

Think about which operation involves adding new data.

---

`Compute`

### --feedback--

Think about which operation involves adding new data.

## --video-solution--

2

## --text--

Which HTTP method is typically used for the `Read` operation in CRUD?

## --answers--

`POST`

### --feedback--

Which method is used to request data from a server?

---

`GET`

---

`PUT`

### --feedback--

Which method is used to request data from a server?

---

`DELETE`

### --feedback--

Which method is used to request data from a server?

## --video-solution--

2

## --text--

What is the purpose of the `Delete` operation in CRUD?

## --answers--

To modify data.

### --feedback--

Consider what happens when you no longer need certain data.

---

To remove data.

---

To add new data.

### --feedback--

Consider what happens when you no longer need certain data.

---

To read data.

### --feedback--

Consider what happens when you no longer need certain data.

## --video-solution--

2
