---
id: 672b98be592cfb451f651451
title: What Is a Background Gradient, and How Does It Work?
challengeType: 19
dashedName: what-is-a-background-gradient
---

# --interactive--

A background gradient in CSS is a smooth transition between two or more colors that can be applied to the background of an element. Gradients allow you to create visually appealing backgrounds without needing images.

There are two main types of gradients in CSS: linear gradients and radial gradients.

A linear gradient transitions colors along a straight line. You can define the direction and the colors involved.

Here is the basic syntax:

```css
background: linear-gradient(direction, color-stop1, color-stop2, ...);
```

In this example, we are using the `background` CSS property with a value of the `linear gradient`.

The direction specifies the direction of the gradient. It can be an angle (such as `45deg`), a keyword (such as `to right`, `to bottom`), or a side/corner.

`color-stop` specifies the colors and positions where the gradient transitions occur.

To better understand how linear gradients work, let's take a look at the following example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="linear-gradient"></div>
```

```css
.linear-gradient{
  background: linear-gradient(to right, red, yellow);
  height: 40vh;
}
```

:::

This CSS creates a linear gradient that transitions from `red` on the `left` to `yellow` on the `right`. The gradient is applied to an element with a height of `40%` of the viewport height. You'll learn more about `vh` units in a future lesson.

The `to right` direction means the gradient runs horizontally from left to right.

Another type of gradient would be the `radial` gradient.

A radial gradient transitions colors radiating from an origin (usually the center) outward in a circular or elliptical shape.

Here is the basic syntax:

```css
background: radial-gradient(shape size at position, color-stop1, color-stop2, ...)
```

On the syntax, the `shape` specifies the shape of gradient which could be `circle` or `ellipse`.

The `size` determines the size of the gradient's ending shape which could be `closest-side`, `closest-corner`, `farthest-side`, `farthest-corner`, `contain`, or `cover`.

`position` determines the position of the gradient's center which could be specified using keywords (such as `center`, `top left`, `bottom right`) or precise values (such as `50% 50%`, `10px 20px`).

Lastly, color stops are a list of colors that the gradient transitions through. Each color stop can optionally include a position value (percentage or length) indicating where the color should be placed.

An example would be:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="radial-gradient"></div>
```

```css
.radial-gradient{
  background: radial-gradient(circle closest-side at center, red, yellow 50%, green);
  height: 60vh;
}
```

:::

This CSS creates a circular radial gradient centered in the element. It starts with `red` at the center, transitions to `yellow` at `50%` of the radius, and ends with `green`.

The `closest-side` keyword makes the gradient's ending shape fit the closest side of the element. The gradient is applied to an element with a height of `60%` of the viewport height.

Understanding how to work with CSS gradients can significantly enhance your designs by providing visually appealing backgrounds without the need for images.

With options like linear gradients for smooth transitions and radial gradients for circular effects, they offer both flexibility and creativity in web design.

# --questions--

## --text--

What does the `circle` keyword specify in a `radial-gradient()` function?

## --answers--

The gradient will have a square shape.

### --feedback--

Consider what shape the gradient will take when using the `circle` keyword.

---

The gradient will extend in a diagonal direction.

### --feedback--

Consider what shape the gradient will take when using the `circle` keyword.

---

The gradient will have a circular shape.

---

The gradient will be applied to the text.

### --feedback--

Consider what shape the gradient will take when using the `circle` keyword.

## --video-solution--

3

## --text--

What does the `farthest-corner` keyword do in the size parameter of a `radial-gradient()` function?

## --answers--

It makes the gradient extend to the nearest corner of the element.

### --feedback--

Think about how the size of the gradient affects its coverage relative to the element.

---

It makes the gradient cover the entire element's `width`.

### --feedback--

Think about how the size of the gradient affects its coverage relative to the element.

---

It makes the gradient extend to the farthest corner of the element.

---

It makes the gradient only appear within the element's `padding`.

### --feedback--

Think about how the size of the gradient affects its coverage relative to the element.

## --video-solution--

3

## --text--

In the `radial-gradient(circle at center, red, yellow 50%, green)` function, where is the gradient's center located?

## --answers--

At the top right corner of the element.

### --feedback--

Consider the placement specified by the at center part of the function.

---

At the bottom left corner of the element.

### --feedback--

Consider the placement specified by the at center part of the function.

---

At the center of the element.

---

At the outer edge of the element.

### --feedback--

Consider the placement specified by the at center part of the function.

## --video-solution--

3
