---
id: 67168278ac6df6a799555db5
title: What Are the Roles of the HTML Audio and Video Elements, and How Do They Work?
challengeType: 19
dashedName: what-are-the-roles-of-the-html-audio-and-video-elements
---

# --interactive--

The `audio` and `video` elements allow you to add sound and video content to your HTML documents. The `audio` element supports popular audio formats like mp3, wav, and ogg.
The `video` element supports mp4, ogg, and webm formats.

To include audio content on your web page, you can use the `audio` element with the `src` attribute pointing to the location of your audio file. 

As you can see in the preview window, nothing shows up on the page. To see the previews, you will need to enable the interactive editor.

:::interactive_editor

```html
<audio src="https://cdn.freecodecamp.org/curriculum/js-music-player/cruising-for-a-musing.mp3"></audio>
```

:::

If you want to see the audio player on the page, then you can add the `audio` element with the `controls` attribute.

Press play in the preview window to hear one of Quincy Larson's songs. To hear a different song, change the `src` value to `"https://cdn.freecodecamp.org/curriculum/js-music-player/never-not-favored.mp3"`. To see the previews, you will need to enable the interactive editor.

:::interactive_editor

```html
<audio src="https://cdn.freecodecamp.org/curriculum/js-music-player/cruising-for-a-musing.mp3" controls></audio>
```

:::

The `controls` attribute enables users to manage audio playback, including adjusting volume, and pausing, or resuming playback. The `controls` attribute is a boolean attribute that can be added to an element to enable built-in playback controls. If omitted, no controls will be shown.

Apart from the `src` and `controls` attributes, there are several other attributes that enhance the functionality of the `audio` element. The `loop` attribute is a boolean attribute that makes the audio replay continuously. 

Here's an example of using the `loop` attribute to play one of Quincy Larson's songs titled "Can't stay down". To see the looping in action, enable the interactive editor, scrub the play head close the end of the song and it will restart again once it is finished. 

:::interactive_editor

```html
<audio
  src="https://cdn.freecodecamp.org/curriculum/js-music-player/can't-stay-down.mp3"
  loop
  controls
></audio>
```

:::

Another attribute you can use is the `muted` attribute. When present in the `audio` element, this boolean attribute will start the audio in a muted state. Here's an example of using the `muted` attribute.

To hear the music, enable the interactive editor and click on the volume icon in the audio player. 

:::interactive_editor

```html
<audio
  src="https://cdn.freecodecamp.org/curriculum/js-music-player/can't-stay-down.mp3"
  loop
  controls
  muted
></audio>
```

:::

When it comes to audio file types, there are differences in which browsers support which type. To accommodate this, you can use `source` elements inside the `audio` element and the browser will select the first source that it understands. Here's an example of using multiple `source` elements for an `audio` element:

```html
<audio controls>
  <source src="audio.ogg" type="audio/ogg" />
  <source src="audio.wav" type="audio/wav" />
  <source src="audio.mp3" type="audio/mpeg" />
</audio>
```

The browser will first start with the ogg type, and if it can't play the audio, then it'll move down to the next type in the list.

All the attributes we have learned so far are also supported in the `video` element. Here's an example of using a `video` element with the `loop`, `controls`, and `muted` attributes. 

Add the `autoplay` attribute to the opening `video` tag so the video plays automatically. To interact with the example, you will need to enable the interactive editor.

**NOTE**: The `width` attribute is being used here to make the video smaller and fit better in the preview window. You will learn more about the `width` attribute in future lessons.

:::interactive_editor

```html
<video
  src="https://archive.org/download/BigBuckBunny_124/Content/big_buck_bunny_720p_surround.mp4"
  loop
  controls
  muted
  width="400"
></video>
```

:::

For the `src`, or source attribute, we are using a video called "Big Buck Bunny" from archive.org. If you wanted to display an image while the video is downloading, you can use the `poster` attribute. This attribute is not available for `audio` elements and is unique to the `video` element. Here's an example of using the `poster` attribute with content provided by peach.blender.org.

```html
<video
  src="https://archive.org/download/BigBuckBunny_124/Content/big_buck_bunny_720p_surround.mp4"
  loop
  controls
  muted
  poster="https://peach.blender.org/wp-content/uploads/title_anouncement.jpg?x11217"
  width="400"
></video>
```

# --questions--

## --text--

What attribute allows the audio to start in a muted state?

## --answers--

`mute`

### --feedback--

Remember the attribute that specifically controls the sound state when the audio starts.

---

`quiet`

### --feedback--

Remember the attribute that specifically controls the sound state when the audio starts.

---

`pause`

### --feedback--

Remember the attribute that specifically controls the sound state when the audio starts.

---

`muted`

## --video-solution--

4

## --text--

Which attribute lets you see the play and pause buttons?

## --answers--

`loop`

### --feedback--

Think about the attribute that generates playback for the audio and video UI.

---

`controls`

---

`details`

### --feedback--

Think about the attribute that generates playback for the audio and video UI.

---

`muted`

### --feedback--

Think about the attribute that generates playback for the audio and video UI.

## --video-solution--

2

## --text--

What is the purpose of the `poster` attribute in the `video` element?

## --answers--

To set the video source.

### --feedback--

Consider what you would want to show to the user before the video starts playing.

---

To control the video playback.

### --feedback--

Consider what you would want to show to the user before the video starts playing.

---

To display an image while the video is downloading.

---

To mute the video.

### --feedback--

Consider what you would want to show to the user before the video starts playing.

## --video-solution--

3
