---
id: 672c375857128708d04d0e22
title: How to Use the Attribute Selector to Target Ordered List Elements with the type Attribute?
challengeType: 19
dashedName: how-to-use-the-attribute-selector-to-target-ordered-list-elements-with-the-type-attribute
---

# --interactive--

When working with ordered lists in HTML, the `type` attribute allows you to specify the style of numbering used, such as numerical, alphabetical, or Roman numerals. 

The `type` attribute can be set on an `ol` (ordered list) element to control the numbering format:

- `1` for numerical lists (such as 1, 2, 3, ...),

- `A` for uppercase alphabetical lists (such as A, B, C, ...),

- `a` for lowercase alphabetical lists (such as a, b, c, ...),

- `I` for uppercase Roman numerals (such as I, II, III, ...),

- `i` for lowercase Roman numerals (such as i, ii, iii, ...).

Here's how you can use the attribute selector to target an ordered list with a specific `type` attribute:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<ol type="A">
  <li>Item 1</li>
  <li>Item 2</li>
</ol>
```

```css
ol[type="A"] {
  color: purple;
  font-weight: bold;
}
```

:::

In this example, the CSS rule will apply purple text and bold font weight to any ordered list that uses uppercase alphabetical numbering, which is specified by `type="A"`.

Similarly, you can target ordered lists that use lowercase Roman numerals by selecting those with `type="i"`:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<ol type="i">
  <li>Item 1</li>
  <li>Item 2</li>
</ol>
```

```css
ol[type="i"] {
  color: green;
}
```

:::

This rule will change the text color to green for any ordered list that uses lowercase Roman numerals.

The ability to style ordered lists based on their `type` attribute gives you greater control over the appearance of lists in your document, allowing for customization based on how content is structured.

# --questions--

## --text--

Which CSS selector would you use to target ordered lists that use uppercase alphabetical numbering?

## --answers--

`ol[type="A"]`

---

`ol[type="a"]`

### --feedback--

Consider the attribute value that corresponds to uppercase letters.

---

`ol[type="1"]`

### --feedback--

Consider the attribute value that corresponds to uppercase letters.

---

`ol[type="I"]`

### --feedback--

Consider the attribute value that corresponds to uppercase letters.

## --video-solution--

1

## --text--

How would you target ordered lists that use lowercase Roman numerals?

## --answers--

`ol[type="I"]`

### --feedback--

Think about the value for Roman numerals in lowercase.

---

`ol[type="1"]`

### --feedback--

Think about the value for Roman numerals in lowercase.

---

`ol[type="i"]`

---

`ol[type="A"]`

### --feedback--

Think about the value for Roman numerals in lowercase.

## --video-solution--

3

## --text--

Which attribute is commonly used in HTML to specify the numbering style of an ordered list?

## --answers--

`data-type`

### --feedback--

This attribute defines whether the list is numbered with numbers, letters, or Roman numerals.

---

`type`

---

`style`

### --feedback--

This attribute defines whether the list is numbered with numbers, letters, or Roman numerals.

---

`order`

### --feedback--

This attribute defines whether the list is numbered with numbers, letters, or Roman numerals.

## --video-solution--

2
