---
id: 672acc538e6ef24e9dd3c94f
title: What Are Margins and Padding, and How Do They Work?
challengeType: 19
dashedName: what-are-margins-and-padding
---

# --interactive--

Margin and padding are essential properties in CSS for creating well-structured, readable, and visually appealing web pages.

Margins control the space outside an element, helping to separate it from other elements and define the layout structure, while padding controls the space inside an element, improving content readability and aesthetic appeal.

To better understand the differences between `margin` and `padding`, let's take a look at some examples.

Here is an HTML example of three paragraph elements on the page:

:::interactive_editor

```html
<p>Paragraph one</p>
<p>Paragraph two</p>
<p>Paragraph three</p>
```

:::

To apply spacing to the top of each paragraph element, you can use the `margin-top` property like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<p>Paragraph one</p>
<p>Paragraph two</p>
<p>Paragraph three</p>
```

```css
p {
  margin-top: 20px;
  border: 2px solid black;
}
```

:::

In this example, we are applying `20px` of margin only to the top of each paragraph element.

We also have a solid black border on all four sides so you can see the margin better.

The four different `margin` properties are `margin-top`, `margin-right`, `margin-bottom` and `margin-left`.

Here is an example of using all four properties:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<span>Paragraph one</span>
<p>Paragraph two</p>
<span>Paragraph three</span>
```

```css
p {
  margin-top: 10px;
  margin-right: 20px;
  margin-bottom: 30px;
  margin-left: 40px;
  border: 2px solid black;
}
```

:::

In this example, we are assigning spacing values on all four sides of the paragraph element. A solid black border has also been added so you can see the margins better.

Another way to use the `margin` property is with shorthand notation. You can specify one, two, three, or four values at once. Let’s explore these options together.

When using a singular value on the `margin` shorthand, that exact value will be applied to all four sides of the target element.

Here is an example of using a single value on `margin` shorthand:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<span>Paragraph one</span>
<p>Paragraph two</p>
<span>Paragraph three</span>
```

```css
p {
  margin: 10px;
}
```

:::

This code example will apply `10px` of `margin` equally to all four sides of the paragraph element.

When using two values, the first value applies to the `top` and `bottom`, while the second value applies to the `left` and `right` sides of the element.

Here is an example of using of two values for the `margin` shorthand:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<span>Paragraph one</span>
<p>Paragraph two</p>
<span>Paragraph three</span>
```

```css
p {
  margin: 10px 20px;
}
```

:::

This sets the `top` and `bottom` margins to `10px`, and `20px` for the `left` and `right` margins for the paragraph element.

If three values are provided, the first value applies to the `top` margin, the second value to the `left` and `right` margin, and the third value to the `bottom` margin.

Here is an example to better understand:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<span>Paragraph one</span>
<p>Paragraph two</p>
<span>Paragraph three</span>
```

```css
p {
  margin: 10px 20px 30px;
}
```

:::

This sets the margin to `10px` for the `top`, `20px` for the `left` and `right`, and `30px` for the `bottom`.

When using four values, this gives you more control, as you can independently specify each margin value for each side of the target element.

The first value targets the `top`, the second value targets the `right`, the third value targets the `bottom`, and the fourth value targets the `left`.

Here is an example of using the margin shorthand with four values:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<span>Paragraph one</span>
<p>Paragraph two</p>
<span>Paragraph three</span>
```

```css
p {
  margin: 10px 20px 30px 40px;
}
```

:::

This sets the margin to `10px` for the `top`, `20px` for the `right`, `30px` for the `bottom`, and `40px` for the `left`.

The `padding` property is used to apply space inside the element, between the content and its border.

Like the `margin` property, the four `padding` properties are `padding-top`, `padding-right`, `padding-bottom` and `padding-left`.

Here's an example on how to set the `padding` for a paragraph element:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<span>Paragraph one</span>
<p>Paragraph two</p>
<span>Paragraph three</span>
```

```css
p {
  padding-top: 10px;
  padding-right: 20px;
  padding-bottom: 30px;
  padding-left: 40px;
  border: 2px solid black;
}
```

:::

This sets the padding to `10px` for the `top`, `20px` for the `right`, `30px` for the `bottom`, and `40px` for the `left`.

As you can see that, `padding` is applied to the content which is inside the border, unlike `margin` which applies to outside the border.

Just like the `margin` property, you can also choose to use the shorthand for the `padding` property.

You can either specify one, two, three, or four values on the `padding` shorthand property as well.

Here is an example of using the `padding` shorthand for paragraph element from earlier:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<span>Paragraph one</span>
<p>Paragraph two</p>
<span>Paragraph three</span>
```

```css
p {
  padding: 10px 20px 30px 40px;
  border: 2px solid black;
}
```

:::

In the example, using the shorthand the code will set the padding to `10px` for the `top`, `20px` for the `right`, `30px` for the `bottom`, and `40px` for the `left` of the paragraph element.

# --questions--

## --text--

Which CSS property would you use to create space between the border of an element and its neighboring elements?

## --answers--

`padding`

### --feedback--

This property is used to create space outside the element's border.

---

`border`

### --feedback--

This property is used to create space outside the element's border.

---

`margin`

---

`width`

### --feedback--

This property is used to create space outside the element's border.

## --video-solution--

3

## --text--

Which CSS property would you use to create space between the content of an element and its border?

## --answers--

`padding`

---

`margin`

### --feedback--

This property is used to create space inside the element's border.

---

`border`

### --feedback--

This property is used to create space inside the element's border.

---

`height`

### --feedback--

This property is used to create space inside the element's border.

## --video-solution--

1

## --text--

What is the correct order of values when using the shorthand property for `margin` or `padding` with four values?

## --answers--

`left`, `right`, `top`, `bottom`.

### --feedback--

Think about the direction you would go in a clockwise manner starting from the top.

---

`top`, `left`, `bottom`, `right`.

### --feedback--

Think about the direction you would go in a clockwise manner starting from the top.

---

`top`, `right`, `bottom`, `left`.

---

`right`, `bottom`, `left`, `top`.

### --feedback--

Think about the direction you would go in a clockwise manner starting from the top.

## --video-solution--

3
