---
id: 672acc1e24c1e54df5ad89bd
title: What Is the Difference Between Inline and Block-Level Elements in CSS?
challengeType: 19
dashedName: what-is-the-difference-between-inline-and-block-level-elements-in-css
---

# --interactive--

In HTML and CSS, elements are classified as either **inline elements** or **block-level elements**, and this classification dictates how they behave in the document layout.

Understanding this difference is crucial for controlling how your content is displayed on a webpage.

Block-level elements are elements that take up the full width available to them by default, stretching across the width of their container.

These elements always start on a new line and push other content to the next line, creating a "block" of content.

Block-level elements have the CSS property `display: block;` applied by default. This property ensures that the element stretches to fill the container's width and appears on a new line.

Some common block-level elements are `div` elements, paragraphs, headings, ordered lists, unordered lists, and section elements.

Here is a code example of a block-level element:

:::interactive_editor

```html
<p style="border: 2px solid red;">
  First paragraph
</p>
<p>Second paragraph</p>
```

:::

In this example, we have two paragraph elements where the first one has a red border around it.

The two paragraph elements do not share the same line because they are block level elements by default.

So, both paragraph elements will take up the full width of its container, which in this case is the `body` element.

Block-level elements are ideal when you want content to stack vertically, such as paragraphs, sections, or larger blocks of content. They're commonly used to define the layout and structure of a webpage.

Inline elements, unlike block-level elements, only take up as much width as they need and do not start on a new line. These elements flow within the content, allowing text and other inline elements to appear alongside them.

Inline elements have the CSS property `display: inline;` applied by default. This property ensures that the element remains within the flow of the content and does not break onto a new line.

Common inline elements are `span`, `anchor`, and `img` elements.

Here's an example to better understand inline elements:

:::interactive_editor

```html
<p>This is a
  <span style="color: red; border: 2px solid green;">red</span>
  word inside a paragraph.
</p>
```

:::

In this example, we have a `span` element nested inside of a paragraph element. The `span` element has a `red` text color with a `green` border around it so you can see the highlighted word better.

As you can see, the `span` element only takes up as much space as the word "red" and does not push the following content to a new line.

Inline elements are best used for styling smaller portions of text or content within a line, such as emphasizing a word, creating hyperlinks, or applying specific styles to parts of a paragraph.

# --questions--

## --text--

What is the default behavior of block-level elements in CSS?

## --answers--

They take up as much width as necessary and stay within the flow of content.

### --feedback--

Block-level elements create large "blocks" of content on a webpage.

---

They take up the full width of their container and start on a new line.

---

They are only used for images and links.

### --feedback--

Block-level elements create large "blocks" of content on a webpage.

---

They are always aligned to the center of the page.

### --feedback--

Block-level elements create large "blocks" of content on a webpage.

## --video-solution--

2

## --text--

Which of the following is an example of an inline element?

## --answers--

`div`

### --feedback--

Inline elements do not force other elements to a new line.

---

`p`

### --feedback--

Inline elements do not force other elements to a new line.

---

`span`

---

`section`

### --feedback--

Inline elements do not force other elements to a new line.

## --video-solution--

3

## --text--

How can you change the behavior of a block-level element to behave like an inline element?

## --answers--

Apply `display: inline-block;`

### --feedback--

Think about which display value makes elements stay within the flow of content.

---

Apply `display: flex;`

### --feedback--

Think about which display value makes elements stay within the flow of content.

---

Apply `display: inline;`

---

Apply `display: none;`

### --feedback--

Think about which display value makes elements stay within the flow of content.

## --video-solution--

3
