---
id: 672acc100d59d24da7b4e09c
title: What Are the Different Types of CSS Combinators?
challengeType: 19
dashedName: what-are-the-different-types-of-css-combinators
---

# --interactive--

CSS combinators are used to define the relationship between selectors in CSS. They help in selecting elements based on their relationship to other elements, which allows for more precise and efficient styling.

We will discuss some primary CSS combinators and their use cases, starting with the descendant combinator.

A descendant combinator is used to target elements matched by the second selector if they are nested within an ancestor element that matches the first selector. An ancestor can be a parent element or a parent's parent.

To better understand how this works, let's take a look at an example.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<figure>
  <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="Relaxing Cat">
  <figcaption>A relaxing cat with a border</figcaption>
</figure>
```

```css
figure img {
  border: 4px solid red;
}
```

:::

In the above example, we use the descendant combinator to select all image elements inside `figure` elements and apply a `solid red` border on all four sides.

Note that a `space` is used between the parent and child selector.

In this case, the `figure` would be the parent and the `img` would be the child.

If you had multiple images inside a `figure` element, using the descendant combinator would be a good way to apply a solid black border around each of those images.

Another type of combinator would be the child combinator.

The child combinator (`>`) in CSS is used to select elements that are direct children of a specified parent element.

This combinator targets only elements with a specific parent, making your CSS rules more precise and preventing unintended styling of deeper nested elements.

Let's take a look at the following HTML example:

:::interactive_editor

```html
<div class="container">
  <p>First</p>
  <div>
    <p>Second</p>
  </div>
  <div>
    <p>Third</p>
  </div>
</div>
```

:::

In above HTML structure, the `container` class is applied to a `div` element.

Inside this container, there is a direct child `p` element ("First"), followed by two additional `div` elements, each containing a `p` element ("Second" and "Third").

The first `p` element is a direct child of the `.container` element, while the other two `p` elements are nested inside other `div` elements, making them deeper descendants.

To apply styles to just the direct child of the `container` class, you can use the child combinator like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="container">
  <p>First</p>
  <div>
    <p>Second</p>
  </div>
  <div>
    <p>Third</p>
  </div>
</div>
```

```css
.container > p {
  color: blue;
}
```

:::

In the above example, we are only targeting the direct child of `container` class. This will give the direct child the text color of `blue`.

Because the other two paragraph elements are nested inside `div` elements, they are not considered direct children of the `container` class and will not get the text color of blue.

Another common combinator would be the next-sibling combinator.

The next-sibling combinator (`+`) in CSS selects an element that immediately follows a specified sibling element. This combinator is useful when you want to apply styles to an element that directly follows another element, allowing for targeted styling based on the element's position relative to its siblings.

Let's take a look at the following HTML example:

:::interactive_editor

```html
<figure>
  <img
    src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg"
    alt="A cute orange cat lying on its back."
  />
  <figcaption>A cute orange cat lying on its back.</figcaption>
</figure>
```

:::

Here, we have a `figure` element containing an `img` element followed by a `figcaption` element. The `figcaption` element is the immediate sibling of the `img` element.

If you wanted to apply a black border around the `figcaption` element, you can use the next-sibling combinator like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<figure>
  <img
    src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg"
    alt="A cute orange cat lying on its back."
  />
  <figcaption>A cute orange cat lying on its back.</figcaption>
</figure>
```

```css
img + figcaption {
  border: 4px solid black;
}
```

:::

In this example, the next-sibling combinator (`+`) selects the `figcaption` element that immediately follows the `img` element. The applied CSS rule adds a `4px solid black border` around the `figcaption`.

Another common combinator is the subsequent-sibling combinator.

The subsequent-sibling combinator (`~`) in CSS selects all siblings of a specified element that come after it.

Unlike the next-sibling combinator, which targets only the immediately following sibling, the subsequent-sibling combinator (`~`) can target any siblings that follow the specified element, offering greater flexibility in styling.

Let's take a look at the following HTML example:

:::interactive_editor

```html
<div class="container">
  <h2>Subheading</h2>
  <p>First paragraph.</p>
  <p>Second paragraph.</p>
  <p>Third paragraph.</p>
  <p>Another paragraph element</p>
</div>
```

:::

In this HTML structure, we have an `h2` element followed by four paragraph elements. The paragraph elements are siblings of the `h2` element.

If you want to style all of the paragraph elements that come after the `h2` element, then you can use the subsequent-sibling combinator like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="container">
  <h2>Subheading</h2>
  <p>First paragraph.</p>
  <p>Second paragraph.</p>
  <p>Third paragraph.</p>
  <p>Another paragraph element</p>
</div>
```

```css
h2 ~ p {
  color: green;
}
```

:::

In this example, all paragraph elements following the `h2` element will have the text color green.

The subsequent-sibling combinator (`~`) targets all paragraph siblings that appear after the `h2` element, regardless of whether they are immediate siblings.

In conclusion, understanding and using various CSS combinators allows you to apply precise styles to your HTML elements, enhancing the control and flexibility of your design.

By mastering these selectors, you can create more sophisticated and targeted styling rules that improve both the appearance and functionality of your web pages.

# --questions--

## --text--

Which CSS rule will style all `span` elements that are inside `div` elements, regardless of how deeply they are nested?

## --answers--

```css
div > span {
  color: red;
}
```

### --feedback--

Consider the combinator that applies to elements within any level of nesting inside the specified parent.

---

```css
div + span {
  color: red;
}
```

### --feedback--

Consider the combinator that applies to elements within any level of nesting inside the specified parent.

---

```css
div ~ span {
  color: red;
}
```

### --feedback--

Consider the combinator that applies to elements within any level of nesting inside the specified parent.

---

```css
div span {
  color: red;
}
```

## --video-solution--

4

## --text--

Which CSS rule will style only the direct child `li` elements of `ul` elements?

## --answers--

```css
ul > li {
  font-weight: bold;
}
```

---

```css
ul li {
  font-weight: bold;
}
```

### --feedback--

Think about the combinator that targets elements that are direct children of a specified parent.

---

```css
ul + li {
  font-weight: bold;
}
```

### --feedback--

Think about the combinator that targets elements that are direct children of a specified parent.

---

```css
ul ~ li {
  font-weight: bold;
}
```

### --feedback--

Think about the combinator that targets elements that are direct children of a specified parent.

## --video-solution--

1

## --text--

Which CSS rule will style the first `p` element that immediately follows any `h1` element?

## --answers--

```css
h1 > p {
  margin-top: 0;
}
```

### --feedback--

Consider the combinator that applies to an element immediately following a specified sibling.

---

```css
h1 + p {
  margin-top: 0;
}
```

---

```css
h1 ~ p {
  margin-top: 0;
}
```

### --feedback--

Consider the combinator that applies to an element immediately following a specified sibling.

---

```css
h1 p {
  margin-top: 0;
}
```

### --feedback--

Consider the combinator that applies to an element immediately following a specified sibling.

## --video-solution--

2
