---
id: 672acc03c257524d6a5151e8
title: How Do Width and Height Work?
challengeType: 19
dashedName: how-do-width-and-height-work
---

# --interactive--

In CSS, the `width` and `height` properties are used to control the dimensions of elements on a webpage.

These properties can be defined in different units such as pixels (`px`), percentages (`%`), viewport units (`vw`, `vh`), and more.

The `width` property specifies the width of an element. If you do not specify a width, then the default is set to `auto`. This lets the browser determine the element's width based on its content, parent, and display type. For a `div` element, `width: auto` makes it expand to fill the full width of its parent container.

The `height` property specifies the height of an element. Similarly, the height is `auto` by default, which means it will adjust to the content inside.

Here's an example using the `width` and `height` properties:

:::interactive_editor

```html
<head>
  <style>
    .box {
      width: 100px;
      height: 100px;
      background-color: skyblue
    }
  </style>
</head>
<body>
  <div class="box"></div>
</body>
```

:::

In this example, we have a `div` element with class named `box`. This element will be occupying `100px` in height and width, whereas the background color will be `skyblue`.

Pixels are a fixed-size unit of measurement in CSS, providing precise control over dimensions. 

The `min-width` property specifies the minimum width an element can be. Even if the content inside is smaller, the element won’t shrink below this value.

The `min-height` specifies the minimum height an element can be. It ensures that the element does not become shorter than the set value.

Here is an example:

:::interactive_editor

```html
<head>
  <style>
    .box {
      width: 50px;
      min-width: 100px;
      height: 50px;
      min-height: 100px;
      background-color: lightcoral;
    }
  </style>
</head>
<body>
  <div class="box"></div>
</body>
```

:::

The above example demonstrates how `min-width` and `min-height` work.

Even though the box has its `width` and `height` set to 50px, it will actually be `100px` by `100px`. This is because the `min-width` and `min-height` are set to `100px`, which are larger than the specified `width` and `height`.

Remember, if `min-width` or `min-height` are larger than the `width` or `height`, they will override the smaller values. This ensures that elements don't become too small, which is important for maintaining a consistent and usable design.

The `max-width` specifies the maximum width an element can grow to, even if there is enough space for it to be wider.

The `max-height` specifies the maximum height an element can grow to, regardless of the content size.

Here is an example:

:::interactive_editor

```html
<head>
  <style>
    .box {
      width: 200px;
      max-width: 150px;
      height: 200px;
      max-height: 150px;
      background-color: lightgreen;
    }
  </style>
</head>
<body>
  <div class="box"></div>
</body>
```

:::

The above example demonstrates how `max-width` and `max-height` override `width` and `height`. Even though the box is set to `200px` by `200px`, it will actually be `150px` by `150px`. This is because the `max-width` and `max-height` are set to `150px`, which is smaller.

Remember, when `max-width` or `max-height` are smaller than `width` or `height`, they take precedence. This is important for controlling the maximum size of elements in your layouts.

CSS prioritizes `min-width` and `min-height` over `width` and `height`. `max-width` and `max-height` restrict dimensions if values exceed their limits.

For example, if you set `width` to `600px` and `max-width` to `500px`, the element will be limited to `500px` wide. The `max-width` overrides the wider setting, keeping the element within the specified maximum size.

This ensures elements stay within desired size ranges, regardless of standard width and height values.

# --questions--

## --text--

What will happen if you set `width: 600px;` and `max-width: 500px;` on a `div` element?

## --answers--

The element will be `600px` wide.

### --feedback--

Think about which property takes precedence in such a situation.

---

The element will be `500px` wide.

---

The element will be `550px` wide.

### --feedback--

Think about which property takes precedence in such a situation.

---

The element will be `100px` wide.

### --feedback--

Think about which property takes precedence in such a situation.

## --video-solution--

2

## --text--

If you set `min-height: 200px` and `height: 150px` on an element, what will be the `height` of the element?

## --answers--

`150px`

### --feedback--

Consider how `min-height` influences the final height.

---

`100px`

### --feedback--

Consider how `min-height` influences the final height.

---

`200px`

---

`250px`

### --feedback--

Consider how `min-height` influences the final height.

## --video-solution--

3

## --text--

Which of the following is NOT a valid unit used with the width property?

## --answers--

`hv`

---

`px`

### --feedback--

Review the beginning of the lesson for the answer.

---

`%`

### --feedback--

Review the beginning of the lesson for the answer.

---

`vw`

### --feedback--

Review the beginning of the lesson for the answer.

## --video-solution--

1
