---
id: 672acbbe2891564c4e316164
title: What Is the Basic Anatomy of a CSS Rule?
challengeType: 19
dashedName: what-is-the-basic-anatomy-of-a-css-rule
---

# --interactive--

CSS is responsible for the styles of a web page. All of these styles are made up of various CSS rules.

A CSS rule is made up of two main parts: a **selector** and a **declaration** block.

Let's take a look at the basic syntax:

```css
selector {
  property: value;
}
```

A selector is a pattern used in CSS to identify and target specific HTML elements for styling.

Examples of selectors include type selectors, class selectors, and ID selectors.

The curly braces provided in the basic syntax are known as a declaration block. A declaration block applies a set of styles for a given selector, or selectors.

Inside the declaration block, you will have a series of declarations. Each declaration consists of a property and a value.

The property is the CSS identifier that specifies which feature is being styled. An example of a property would be the `background-color` property.

The value would be the specific setting applied to that property. For example, if the property is `background-color`, a value could be `purple`, which sets the background color to purple.

After each property name, you need to place a colon, and after each value, you should have a semicolon.

Now that you know the syntax for a CSS rule, let's take a look at an example. Enable the interactive editor and click on the `styles.css` tab to see the CSS code.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<h1>Learning about CSS</h1>

<p>Example paragraph element</p>
<p>Another example paragraph element</p>
```

```css
p {
  color: blue;
}
```

:::

In this CSS rule, a type selector targets all paragraph elements on the page.

Inside the declaration block, there is a one declaration.

The declaration consists of the `color` property with a value set to `blue`. This will change the text color for all paragraph elements to `blue`.

If you want to apply the same set of styles to multiple selectors, you can create a selector list with each selector separated by a comma.

Here is an example of styling multiple selectors (to interact with the example, enable the interactive editor): 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<h1 id="title">Example heading</h1>
<h2 class="subheading">Example subheading</h2>
<p>This paragraph is not affected by the selector.</p>
```

```css
#title,
.subheading {
  color: navy;
}
```

:::

In this selector list, there is an `id` selector targeting the HTML element with the `id` value of `title`. All `id` selectors must start with a hash `#` symbol.

Then there is a comma followed by a `class` selector that targets all HTML elements with the `class` value of `subheading`. All class selectors must start with a dot `.`

The entire selector list will receive the same styling, with the text color set to `navy`.

# --questions--

## --text--

What is the purpose of a selector in a CSS rule?

## --answers--

To apply styles to HTML elements.

### --feedback--

The selector is the first part of the CSS rule and specifies the elements to be styled.

---

To determine which HTML elements the rule will apply to.

---

To define the specific style properties and values.

### --feedback--

The selector is the first part of the CSS rule and specifies the elements to be styled.

---

To create new HTML elements.

### --feedback--

The selector is the first part of the CSS rule and specifies the elements to be styled.

## --video-solution--

2

## --text--

Which of the following CSS rules correctly changes the text color of all paragraph elements to `blue`?

## --answers--

```css
p {
  background-color: blue;
}
```

### --feedback--

Look for the selector that targets all paragraph elements and the property that changes text color.

---

```css
p {
  color: blue;
}
```

---

```css
.p {
  color: blue;
}
```

### --feedback--

Look for the selector that targets all paragraph elements and the property that changes text color.

---

```css
#p {
  color: blue;
}
```

### --feedback--

Look for the selector that targets all paragraph elements and the property that changes text color.

## --video-solution--

2

## --text--

Given the following HTML, which CSS rule correctly sets `h1` and `h2` text color to `green`?

```html
<link rel="stylesheet" href="styles.css">

<h1 id="title">Example heading</h1>
<h2 class="subheading">Example subheading</h2>
<p>Paragraph element</p>
```

## --answers--

```css
#title
.subheading {
  color: green;
}
```

### --feedback--

Refer back to the end of the lesson for the correct syntax.

---

```css
#title,
.subheading {
  color: green;
}
```

---

```css
.title,
#subheading {
  color: green;
}
```

### --feedback--

Refer back to the end of the lesson for the correct syntax.

---

```css
#title,
#subheading {
  color: green;
}
```

### --feedback--

Refer back to the end of the lesson for the correct syntax.

## --video-solution--

2
