---
id: 672baae11d06c867a16f64e1
title: What Is Progressive Enhancement?
challengeType: 19
dashedName: what-is-progressive-enhancement
---

# --description--

Progressive enhancement is a design approach that ensures all users, regardless of browser or device, can access the essential content and functionality of an application. 

It focuses on delivering a core experience that works for everyone, while offering extra features and improvements to users with more advanced browsers or better internet connections.

The progressive enhancement approach lives by these core principles:

- All core content and basic functionality should be accessible on all browsers
- All advanced layouts should be provided through external CSS stylesheets
- All advanced functionality should be provided through external JavaScript files
- A user's browser preferences should be respected

Using a progressive enhancement approach makes your applications more accessible because all core content and functionality should not be blocked in unsupported environments. 

In terms of speed, a progressive enhancement approach can also help improve the performance of your applications. 

Those users that are working with slower internet connection speeds will still be able to access the content because the browser will download the necessary resources first.

When it comes to SEO, progressive enhancement can also help improve the visibility of your applications. 

Search engines will be able to crawl the content of your applications because the core content is available in the initial HTML response.

While some have criticized this approach deeming that it is not always realistic for applications that rely heavily on JavaScript for their functionality, it is still a good practice to follow when building applications.

# --questions--

## --text--

What is the main goal of progressive enhancement?

## --answers--

To ensure that the application is heavily reliant on JavaScript.

### --feedback--

Think about accessible content for all users.

---

To ensure all users, regardless of browser or device, can access the essential content and functionality of an application.

---

To ensure that the latest complex features are available to all users.

### --feedback--

Think about accessible content for all users.

---

To ensure that the application is only available to users with the latest browsers.

### --feedback--

Think about accessible content for all users.

## --video-solution--

2

## --text--

Which of the following is NOT a core principle of progressive enhancement?

## --answers--

A user's browser preferences should be respected.

### --feedback--

Think about which option does not respect the user's preferences.

---

All advanced layouts should be provided through external CSS stylesheets.

### --feedback--

Think about which option does not respect the user's preferences.

---

A user's browser preferences should be ignored.

---

All advanced functionality should be provided through external JavaScript files.

### --feedback--

Think about which option does not respect the user's preferences.

## --video-solution--

3

## --text--

What is a common criticism of the progressive enhancement approach?

## --answers--

It is not always realistic for applications that rely heavily on JavaScript for their functionality.

---

It can result in a less engaging user experience on modern devices due to its focus on backward compatibility.

### --feedback--

Think about the limitations of the approach and the amount of resources needed.

---

It leads to bloated web pages with excessive code and resources that are not needed by modern browsers.

### --feedback--

Think about the limitations of the approach and the amount of resources needed.

---

It requires extensive browser testing on older, less capable browsers, which can be time-consuming and expensive.

### --feedback--

Think about the limitations of the approach and the amount of resources needed.

## --video-solution--

1
