---
id: 672baacb7f2f446728e77efe
title: What Is the Importance of Whitespace in Design?
challengeType: 19
dashedName: what-is-the-importance-of-whitespace-in-design
---

# --description--

White space refers to any type of space around elements like images, text, and buttons. White space is important in design because it helps to create a balance between the elements on the page.

Let's take a look at some examples of how white space can be used effectively in design.

For example, let's consider a call-to-action (CTA) button. CTAs are used to encourage users to take a specific action like signing up for a newsletter or making a purchase. 

On the freeCodeCamp homepage, the CTA button is visually separated from other elements. The image below shows this button, with a certain amount of space around it.

<img src="https://cdn.freecodecamp.org/curriculum/lecture-transcripts/what-is-the-importance-of-whitespace-in-design-1.png" alt="Call-to-action button on the freeCodeCamp homepage with yellow background and black text reading: Get started (it's free). The button is centered on its own line with ample white space above and below.">

By using white space effectively, we can help to make a CTA button more prominent and encourage users to click on it.

Now let's take a closer look at the different types of white space.

This first example uses both macro and active white space. Macro white space is the space between larger elements like images, text blocks, and buttons.

Active white space is the space that is intentionally created to help guide the user's eye and draw attention to certain elements on the page.

In contrast to active white space, there is also passive white space. Passive white space is the space that is left over after all the elements on a page have been placed.

Another type of whitespace would be micro white space. This is the space between individual characters in a line of text.

The image below shows the Frequently Asked Questions section on the freeCodeCamp homepage, where this spacing allows you to read each question and answer easily.

<img src="https://cdn.freecodecamp.org/curriculum/lecture-transcripts/what-is-the-importance-of-whitespace-in-design-2.png" alt="The Frequently Asked Questions section on the freeCodeCamp homepage, with text spaced sufficiently between each letter.">

Micro white space is important because it helps to improve readability and legibility, making it easier for users to scan and understand the content.

When designing your web pages, you always want to be mindful of the law of proximity. This law states that elements that are close together are perceived as being related, while elements that are far apart are perceived as being unrelated.

You can use white space to help group related elements together and help navigate users through the content on your page.

# --questions--

## --text--

What is macro white space?

## --answers--

The space between individual characters in a line of text.

### --feedback--

Think about space seen around larger elements.

---

The space around images only.

### --feedback--

Think about space seen around larger elements.

---

The space around text only.

### --feedback--

Think about space seen around larger elements.

---

The space between larger elements like images, text blocks and buttons.

## --video-solution--

4

## --text--

What is active white space?

## --answers--

Space that is only for text elements on a page.

### --feedback--

Think about the purpose of active white space.

---

Space that is for figure elements on a page.

### --feedback--

Think about the purpose of active white space.

---

Space that is for list items on a page.

### --feedback--

Think about the purpose of active white space.

---

Space that is intentionally created to help guide the user's eye and draw attention to certain elements on the page.

## --video-solution--

4

## --text--

What is passive white space?

## --answers--

Space that is left over after all the elements on a page have been placed.

---

Space that is only for text elements on a page.

### --feedback--

Think about how this space contrasts to active white space.

---

Space that is for image elements on a page.

### --feedback--

Think about how this space contrasts to active white space.

---

Space that is for nav elements on a page.

### --feedback--

Think about how this space contrasts to active white space.

## --video-solution--

1
