---
id: 67db32542c7075361b06024c
title: What Is Regression Testing?
challengeType: 19
dashedName: what-is-regression-testing
---

# --description--

As an application continues to grow, it is not uncommon to have situations where new changes unintentionally break existing functionality. This is known as a regression.

To help catch these issues before they happen, you can use regression testing. Regression testing is when you re-run functional tests against parts of your application to ensure that everything still works as expected. If you've implemented bug fixes, enhancements, or even have updates to your configuration, then it's a good idea to perform regression testing.

There are different tools that you can use to perform regression testing. They include Puppeteer, Playwright, Selenium, and Cypress.

There are also a few testing techniques to be aware of when it comes to regression testing. The first is called unit regression testing. This is where you have a list of items that need to be tested each time major changes or fixes are implemented into the app.

Another testing technique is called partial regression testing. This involves targeted approaches to ensure that new changes have not broken specific aspects of the application.

Finally, there's complete regression testing. This is the most time-consuming and detailed option, which looks at all the functionalities affected by the recent changes in the codebase and runs tests against them.

It's important to note that retesting and regression testing are different. Retesting is used to check for known issues and ensure that they have been resolved, whereas regression testing searches for unknown issues that might have occurred through recent changes in the codebase.

# --questions--

## --text--

What is retesting?

## --answers--

This re-runs tests for issues found in JavaScript files only and fixes them.

### --feedback--

Review the last part of the lesson where this was discussed.

---

This tests for unknown issues that might have resulted in recent additions to the codebase.

### --feedback--

Review the last part of the lesson where this was discussed.

---

This re-runs tests for known HTML-related issues and fixes them.

### --feedback--

Review the last part of the lesson where this was discussed.

---

This tests for known issues and ensures that they have been resolved.

## --video-solution--

4

## --text--

What is a regression in software?

## --answers--

This is where new changes unintentionally break JavaScript code only.

### --feedback--

Review the beginning of the lesson where this was discussed.

---

This is where changes break existing HTML and CSS code only.

### --feedback--

Review the beginning of the lesson where this was discussed.

---

This is where new changes unintentionally break existing functionality.

---

This is where new changes enhance existing functionality.

### --feedback--

Review the beginning of the lesson where this was discussed.

## --video-solution--

3

## --text--

Which of the following is NOT a commonly used tool for regression testing?

## --answers--

Svelte

---

Puppeteer

### --feedback--

Review the beginning of the lesson where this was discussed.

---

Playwright

### --feedback--

Review the beginning of the lesson where this was discussed.

---

Selenium

### --feedback--

Review the beginning of the lesson where this was discussed.

## --video-solution--

1
