---
id: 67d2ff7a461f62a03e3d1861
title: What Is Performance Testing?
challengeType: 19
dashedName: what-is-performance-testing
---

# --description--

If a software application is slow to respond or unstable, that will lead to a poor user experience. Performance testing is what you do when you test an application's speed, responsiveness, scalability, and stability under different workloads. The goal is to resolve any type of performance bottleneck before it reaches your users.

In this lesson, we will go through a few types of performance testing.

The first type is load testing. A load in this context refers to the amount of work or demand put on a system. Load testing determines how a system behaves during normal and peak load times. The goal is to analyze metrics like response times and resource usage and determine if the current software build is ready or not.

Another type of testing is stress testing. This is where you test your application in extreme loads and see how well your system responds to the higher load. The goal here is to identify any bottlenecks and vulnerabilities by testing the system beyond its limits.

The next type of performance testing is soak testing, also known as endurance testing. This is a type of load testing where you test the system with a higher load for an extended period of time. The goal here is to determine any types of memory leaks and performance degradation.

Another type of testing is spike testing. This is where you dramatically increase and decrease the loads and analyze the system's reactions to the changes. The goal here is to see if your system will fail with these dramatic changes in the load.

Finally, there's breakpoint testing, also known as capacity testing. This is where the load will slowly increment over time to the point where the system starts to fail or degrade. The goal here is to better understand the system's limits and capacities.

These are just a few types of performance testing you can do on your applications. Since performance plays a vital role in software development, it is important that you perform these types of tests to ensure that your application doesn't have any major issues and provides a smooth experience for users.

# --questions--

## --text--

What is performance testing?

## --answers--

Testing for an application's linting, formatting, and stability under different workloads.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Testing for an application's accessibility, scalability and linting under different workloads.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Testing for an application's version control, scalability and formatting under different workloads.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Testing for an application's speed, responsiveness, scalability and stability under different workloads.

## --video-solution--

4

## --text--

Which of the following is NOT a type of performance testing?

## --answers--

CPU testing

---

Load testing

### --feedback--

One of these options refers to the "brain" of a computer and is not a type of performance testing.

---

Stress testing

### --feedback--

One of these options refers to the "brain" of a computer and is not a type of performance testing.

---

Breakpoint testing

### --feedback--

One of these options refers to the "brain" of a computer and is not a type of performance testing.

## --video-solution--

1

## --text--

Which of the following tests dramatically increase and decrease the loads and analyze the system's reactions to the changes?

## --answers--

Load testing

### --feedback--

Refer to the end of the lesson where this was discussed.

---

Spike testing

---

Accessibility testing

### --feedback--

Refer to the end of the lesson where this was discussed.

---

Stress testing

### --feedback--

Refer to the end of the lesson where this was discussed.

## --video-solution--

2
