---
id: 67d2ff33452ce69ea169c872
title: What Is Functional Testing, and How Does It Differ from Unit Testing?
challengeType: 19
dashedName: what-is-functional-testing-and-how-does-it-differ-from-unit-testing
---

# --description--

In prior lessons, you learned how to test small units of code through unit testing. Well, unit testing is part of functional testing. Functional testing checks if the features and functions of the application work as expected.

In this lesson, we will take a look at the differences between functional and non-functional testing.

The goal of functional testing is to test the system as a whole against multiple scenarios to ensure that the system works as expected. An example of functional testing would be smoke testing. Smoke testing is where you perform a preliminary check on the system for basic or critical issues before more extensive testing is done.

In contrast, non-functional testing focuses on things like performance and reliability.

A real test scenario for functional testing would be a user login. A user should be able to log in to the application with their username and password. If successful, they should be able to access their account information. If there is an issue, then that error needs to be handled properly. When you are writing tests, you need to account for all types of success and failure scenarios.

An example of non-functional testing would be to test the performance of your application under different network conditions. In a future lesson, you will learn more about performance testing.

The reasons why functional testing is so important is because you want to identify bugs early on in your application. You also want to make sure that your application meets the requirements that were laid out at the beginning of the planning phase. Lastly, you want to ensure that your users have a good user experience. Users should not struggle to use your application or be blocked by broken features and system failures.

# --questions--

## --text--

What is functional testing?

## --answers--

This tests for accessibility issues only and ensures there is 100% test coverage.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

This tests for performance issues and ensures the application performance is strong.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

This tests the system as a whole to ensure that the system works as expected.

---

This tests for CSS issues only and ensures there is 100% test coverage.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

3

## --text--

Which of the following is an example of non-functional testing?

## --answers--

Testing the CSS of your application to make sure the styles look correct.

### --feedback--

Refer to the end of the lesson where this was discussed.

---

Testing the HTML of your application to ensure there are no bugs.

### --feedback--

Refer to the end of the lesson where this was discussed.

---

Testing the JavaScript files in your application to ensure they only use arrow functions.

### --feedback--

Refer to the end of the lesson where this was discussed.

---

Testing the performance of your application under different network conditions.

## --video-solution--

4

## --text--

Which of the following is an example of functional testing?

## --answers--

Agile testing

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Regex testing

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Smoke testing

---

Class testing

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

3
