---
id: 687e947ae3ea7d2867c3d0e1
title: What Are Some Command Options and Flags?
challengeType: 19
dashedName: what-are-some-command-options-and-flags
---

# --description--

Let's learn about command options and flags.

In a previous lesson, you learned about passing arguments to commands such as `touch readme.md`. Options, or flags, are special arguments you can pass to a command that affect the way it behaves. The two terms are used interchangeably, though "flags" tends to be used more specifically for options that serve as an on/off toggle.

Options are typically prefixed with one or two hyphen (`-`) symbols, which helps provide a visual distinction between an option and an argument. First, let's look at the two-hyphen, or "long form", syntax.

Many applications, such as `ls`, accept a `--version` flag, which prints the current version of the application to the terminal instead of running the application's commands.

Many applications also offer a `--help` flag, which prints instructions on how to use the application.

The one-hyphen, or "short form", syntax typically uses options that are a single letter. For example, the `-a` flag with `ls` lists all files, including hidden files that start with a dot (`.`), like `.env`.

The advantage of these short options is that you can chain multiple flags together. Instead of `ls --all --human-readable --size` you can use the single letters all at once with `ls -ahs`.

Some options expect a value to be passed to them.

When using long-form options, you typically need to use an equal sign. In this syntax, the value is directly concatenated to the option with the equal (`=`) symbol. Here is an example of modifying the behavior of `ls` to either include or exclude colors:

```bash
ls --color=never
```

When using short-form options, you typically separate the value with a space. For example, here are the long and short form options for setting the `width` of the `ls` result:

```bash
ls -w 50
```

```bash
ls --width=50
```

Notice how the short form uses `-w 50`, while the long form uses `--width=50`. This distinction is important to know, to avoid passing an option value as a positional argument instead.

But if you are ever unsure, remember you can usually use the `--help` flag to see the expected syntax for options!

# --questions--

## --text--

What is the difference between "long form" and "short form" syntax for command options?

## --answers--

Long form uses a single hyphen while short form uses two hyphens.

### --feedback--

Think about the number of hyphens used in each form.

---

Long form uses two hyphens while short form uses a single hyphen.

---

Long form is only used for version information.

### --feedback--

Think about the number of hyphens used in each form.

---

There is no difference between the two forms.

### --feedback--

Think about the number of hyphens used in each form.

## --video-solution--

2

## --text--

What is the advantage of using short form options like `-ahs`?

## --answers--

They require less memory to process.

### --feedback--

Consider how multiple flags can be combined in short form.

---

They are easier to remember.

### --feedback--

Consider how multiple flags can be combined in short form.

---

Multiple options can be chained together.

---

They always work better than long form options.

### --feedback--

Consider how multiple flags can be combined in short form.

## --video-solution--

3

## --text--

When using a long-form option that requires a value, what syntax is typically used?

## --answers--

`--option value`

### --feedback--

Remember the example of setting `width` with the long form option.

---

`--option=value`

---

`-o value`

### --feedback--

Remember the example of setting `width` with the long form option.

---

`-o=value`

### --feedback--

Remember the example of setting `width` with the long form option.

## --video-solution--

2
