---
id: 687e944b821130283dc83b2e
title: What Is Bash, and What Are Some Basic Commands?
challengeType: 19
dashedName: what-is-bash-and-what-are-some-bash-commands
---

# --description--

Let's learn about Bash and some of its basic commands.

Bash stands for Bourne Again SHell, and is arguably the most common shell you will encounter in Unix-like environments. As such, it can be very beneficial to understand how to navigate this shell and use the common commands.

The first command is `pwd`, which prints the current working directory to the terminal. The "working directory" refers to the directory the terminal is currently pointed at, which is an important thing to know for many of these other commands.

It is entirely possible that your terminal is pointed to the wrong directory. The `cd` command allows you to change directories. You can specify an absolute path, prefixed with a forward slash (`/`), a relative path with no prefix, and use the double-dot (`..`) syntax to move up to the parent directory.

The next command is `ls`, which lists the contents of your current working directory. This is helpful to see if a file or folder exists in your directory. The `ls` command also takes flags to show hidden files (the `-a` flag), file permissions (the `-l` flag), and other features. You will learn more about command flags in the next lesson. You can also use `less` or `cat` to view the contents of a file. 

What if the directory does not contain the file or folder you need? There are commands called `mkdir` and touch that allow you to create them. `mkdir` creates a new directory, or folder, and `touch` creates a new file. Both of these commands accept the name of the file or folder you want to create. For example, `touch readme.md` creates a new Markdown file named `readme.md`.

Maybe your new file should not have been named `readme.md`, but it should have been `readthis.md`. Thankfully, the `mv` command allows you to move (or rename) a file. It takes the old file name and the new file name.

The `rm` command allows you to remove (or delete) a file, and with the `-r` flag will delete a directory. Sometimes a file might be protected, and you'll need to include the `-f` flag.

The `cp` command can be used to copy a file or directory to a new location. Unlike the `mv` command, the `cp` command does not remove the original file - and in order to copy a directory, you'll need to pass the `-r` flag.

The `echo` command can be thought of as the Bash equivalent of a `console.log()` or `print()` function. `echo` takes a string argument, wrapped in quotes, and prints it to the terminal. This might seem silly to run in the terminal, just to get text back in the terminal, but you can actually chain `echo` to a control symbol. The `>` symbol allows you to specify a filename to create or overwrite with the new string, like `echo "Naomi was here." > readme.md`, and the `>>` symbol will append to the file.

There are many more Bash commands available to you, such as `head`, `tail`, `chown`, and `chmod`. It would be impossible to cover them all in this lesson. But you can use the man command to see the manual or help page for nearly any command.

You'll likely remember the commands you use most frequently. And for the rest, you can always check the man page.

# --questions--

## --text--

What does the `pwd` command do in Bash?

## --answers--

Changes directories.

### --feedback--

Think about what information this command provides to help you navigate.

---

Prints the current working directory.

---

Creates a new file.

### --feedback--

Think about what information this command provides to help you navigate.

---

Lists directory contents.

### --feedback--

Think about what information this command provides to help you navigate.

## --video-solution--

2

## --text--

Which command would you use to create a new file called `notes.txt`?

## --answers--

`mkdir notes.txt`

### --feedback--

The lesson mentions a specific command for creating new files.

---

`cd notes.txt`

### --feedback--

The lesson mentions a specific command for creating new files.

---

`touch notes.txt`

---

`ls notes.txt`

### --feedback--

The lesson mentions a specific command for creating new files.

## --video-solution--

3

## --text--

If you wanted to rename a file from `oldname.txt` to `newname.txt`, which command would you use?

## --answers--

`rm oldname.txt newname.txt`

### --feedback--

The lesson mentions that this command can be used for both moving and renaming files.

---

`mv oldname.txt newname.txt`

---

`touch newname.txt`

### --feedback--

The lesson mentions that this command can be used for both moving and renaming files.

---

`cd oldname.txt newname.txt`

### --feedback--

The lesson mentions that this command can be used for both moving and renaming files.

## --video-solution--

2
