---
id: 67d2f759154eac7b4d5cb1bf
title: How to Improve the Perceived Performance of Features?
challengeType: 19
dashedName: how-to-improve-the-perceived-performance-of-features
---

# --description--

As we know, perceived performance isn't just about how fast a site actually is — it's about how fast it feels to users. So, for example, if you have ever used a website that felt slow, even though it wasn't? That's perceived performance — how fast a site feels to the user.

Small tweaks can make a huge difference in the user experience. Let's explore some practical ways to improve perceived performance!

Spinners can make users feel like they're waiting longer than they actually are. Instead, try skeleton screens — gray placeholders that mimic real content and gradually load in:

```html
<div class="skeleton"></div>
<script>
  setTimeout(() => {
    document.querySelector(".skeleton").innerHTML = "✅ Content Loaded!";
  }, 2000);
</script>
```

Users feel like the page is loading progressively, rather than waiting in the dark.

In addition to this, users shouldn't have to wait for everything to load before they can start interacting. Load important content first, then load the rest in the background. We looked at this previously with lazy loading:

```html
<img src="placeholder.jpg" data-src="real-image.jpg" class="lazy">
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const lazyImages = document.querySelectorAll("img.lazy");
    lazyImages.forEach(img => {
      img.src = img.dataset.src;
    });
  });
</script>
```

This makes the page feel responsive, even if not everything has loaded yet.

Now - what if your site could predict what the user will click next? With preloading, you can fetch the next page before they request it:

```html
<link rel="preload" href="next-page.html" as="document">
```

This reduces perceived loading time to near zero when users navigate.

And finally, users don't like uncertainty. When they click a button, acknowledge their action instantly:

```html
<button onclick="this.innerText='⏳ Processing...'; setTimeout(() => this.innerText='✅ Done!', 2000);">
  Click Me
</button>
```

This means that, even if there's a delay, the user feels like something is happening.

So, in conclusion, improving perceived performance isn't just about raw speed, it's about how speed feels to the user. Use skeleton screens, prioritize important content, preload smartly, and give instant feedback to make your site feel faster.

# --questions--

## --text--

What is the perceived performance?

## --answers--

How fast a site feels to the user.

---

How fast a page loads.

### --feedback--

Think about how a user is waiting for a web page to load.

---

How slow a page loads.

### --feedback--

Think about how a user is waiting for a web page to load.

---

How fast a users performance is.

### --feedback--

Think about how a user is waiting for a web page to load.

## --video-solution--

1

## --text--

Which of the following is an example of preloading?

## --answers--

Fetching the next page before a user requests it.

---

Fetching a webpage's content after a user interacts with the page.

### --feedback--

Think about predicting what the user will click next.

---

Displaying placeholder content while waiting for resources to load.

### --feedback--

Think about predicting what the user will click next.

---

Caching assets for offline use after the page has loaded.

### --feedback--

Think about predicting what the user will click next.

## --video-solution--

1

## --text--

What is an example of a skeleton screen?

## --answers--

A screen displaying an image of a skeleton.

### --feedback--

Think about users feeling like the page is loading progressively, rather than waiting in the dark.

---

The bare bones of a web page.

### --feedback--

Think about users feeling like the page is loading progressively, rather than waiting in the dark.

---

A gray placeholder that mimics real content and gradually loads in.

---

A loading screen that shows simple shapes or text as the page content loads.

### --feedback--

Think about users feeling like the page is loading progressively, rather than waiting in the dark.

## --video-solution--

3
